"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isGettingStartedEnabled = isGettingStartedEnabled;
var _searchSharedUi = require("@kbn/search-shared-ui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Check if the Getting Started feature is enabled via feature flag.
 * This is a client-side synchronous evaluation.
 * Default to false if the feature flag is not set.
 *
 * @param featureFlags - The FeatureFlags service from core
 * @returns boolean indicating if the feature is enabled
 */
function isGettingStartedEnabled(featureFlags) {
  return featureFlags.getBooleanValue(_searchSharedUi.SEARCH_GETTING_STARTED_FEATURE_FLAG, false);
}