"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchGettingStartedConnectCode = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _gettingStartedTutorials = require("@kbn/search-code-examples/src/getting-started-tutorials");
var _language_selector = require("./language_selector");
var _install_command_code_box = require("./install_command_code_box");
var _section_heading = require("../section_heading");
var _code_box = require("./code_box");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_getting_started/public/components/connect_code/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchGettingStartedConnectCode = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)('python');
  const codeBlockLanguage = _gettingStartedTutorials.Languages[selectedLanguage].codeBlockLanguage;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_section_heading.SearchGettingStartedSectionHeading, {
    icon: "plugs",
    title: _i18n.i18n.translate('xpack.search.gettingStarted.page.codeExample.title', {
      defaultMessage: 'Connect to your application'
    }),
    description: _i18n.i18n.translate('xpack.search.gettingStarted.page.codeExample.description', {
      defaultMessage: 'Choose a language client and connect your application.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            width: calc(${euiTheme.size.xxxxl} * 6);
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_language_selector.LanguageSelector, {
    options: _gettingStartedTutorials.LanguageOptions,
    selectedLanguage: selectedLanguage,
    onSelectLanguage: setSelectedLanguage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_install_command_code_box.InstallCommandCodeBox, {
    selectedLanguage: selectedLanguage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_code_box.CodeBox, {
    selectedLanguage: selectedLanguage,
    codeBlockLanguage: codeBlockLanguage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
};
exports.SearchGettingStartedConnectCode = SearchGettingStartedConnectCode;