"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeBox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _gettingStartedTutorials = require("@kbn/search-code-examples/src/getting-started-tutorials");
var _use_kibana = require("../../hooks/use_kibana");
var _use_elasticsearch_url = require("../../hooks/use_elasticsearch_url");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_getting_started/public/components/connect_code/code_box.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CodeBox = ({
  selectedLanguage,
  codeBlockLanguage
}) => {
  const {
    cloud
  } = (0, _use_kibana.useKibana)().services;
  const elasticsearchUrl = (0, _use_elasticsearch_url.useElasticsearchUrl)();
  const {
    apiKey
  } = (0, _searchApiKeysComponents.useSearchApiKey)();
  const selectedExample = _gettingStartedTutorials.GettingStartedCodeExample[selectedLanguage];
  const codeParams = (0, _react.useMemo)(() => {
    var _cloud$isServerlessEn;
    return {
      elasticsearchURL: elasticsearchUrl,
      apiKey: apiKey || _constants.API_KEY_PLACEHOLDER,
      isServerless: (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : undefined
    };
  }, [elasticsearchUrl, apiKey, cloud]);
  const codeExample = (0, _react.useMemo)(() => {
    return selectedExample.gettingStartedSemantic({
      ...codeParams,
      sampleDocuments: _gettingStartedTutorials.GettingStartedCodeExample.sampleDocs,
      queryObject: _gettingStartedTutorials.GettingStartedCodeExample.queryObject
    });
  }, [selectedExample, codeParams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    fontSize: "m",
    language: codeBlockLanguage,
    overflowHeight: 700,
    "data-test-subj": "gettingStartedExampleCode",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, codeExample);
};
exports.CodeBox = CodeBox;