"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteConnectorById = void 0;
var _cancel_syncs = require("./cancel_syncs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const deleteConnectorById = async (client, id) => {
  // timeout function to mitigate race condition with external connector running job and recreating index
  const timeout = async () => {
    const promise = new Promise(resolve => setTimeout(resolve, 500));
    return promise;
  };
  await Promise.all([(0, _cancel_syncs.cancelSyncs)(client, id), timeout]);
  return await client.transport.request({
    method: 'DELETE',
    path: `/_connector/${id}`
  });
};
exports.deleteConnectorById = deleteConnectorById;