"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareToSpaceSavedObjectsManagementColumn = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _types = require("../types");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/services/columns/share_saved_objects_to_space_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const columnName = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.columnTitle', {
  defaultMessage: 'Spaces'
});
const columnDescription = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.columnDescription', {
  defaultMessage: 'The spaces that this object is currently assigned to'
});
const isolatedObjectTypeTitle = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.isolatedObjectTypeTitle', {
  defaultMessage: 'Isolated saved object'
});
const isolatedObjectTypeContent = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.isolatedObjectTypeContent', {
  defaultMessage: 'This saved object is available in only one space, it cannot be assigned to multiple spaces.'
});
const shareableSoonObjectTypeTitle = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.shareableSoonObjectTypeTitle', {
  defaultMessage: 'Coming soon: Assign saved object to multiple spaces'
});
const shareableSoonObjectTypeContent = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.shareableSoonObjectTypeContent', {
  defaultMessage: 'This saved object is available in only one space. In a future release, you can assign it to multiple spaces.'
});
const globalObjectTypeTitle = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.globalObjectTypeTitle', {
  defaultMessage: 'Global saved object'
});
const globalObjectTypeContent = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.globalObjectTypeContent', {
  defaultMessage: 'This saved object is available in all spaces and cannot be changed.'
});
const Wrapper = ({
  objectType,
  objectNamespaceType,
  spacesApiUi,
  capabilities,
  spaceListProps,
  flyoutProps
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  function listOnClick() {
    setShowFlyout(true);
  }
  function onClose() {
    var _flyoutProps$onClose;
    setShowFlyout(false);
    (_flyoutProps$onClose = flyoutProps.onClose) === null || _flyoutProps$onClose === void 0 ? void 0 : _flyoutProps$onClose.call(flyoutProps);
  }
  const LazySpaceList = (0, _react.useMemo)(() => spacesApiUi.components.getSpaceList, [spacesApiUi]);
  const LazyShareToSpaceFlyout = (0, _react.useMemo)(() => spacesApiUi.components.getShareToSpaceFlyout, [spacesApiUi]);
  const LazySpaceAvatar = (0, _react.useMemo)(() => spacesApiUi.components.getSpaceAvatar, [spacesApiUi]);
  if (objectNamespaceType === 'single' || objectNamespaceType === 'multiple-isolated') {
    const tooltipProps = _constants.SHAREABLE_SOON_OBJECT_TYPES.includes(objectType) ? {
      title: shareableSoonObjectTypeTitle,
      content: shareableSoonObjectTypeContent
    } : {
      title: isolatedObjectTypeTitle,
      content: isolatedObjectTypeContent
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, (0, _extends2.default)({
      type: "minus",
      position: "left",
      delay: "long"
    }, tooltipProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 12
      }
    }));
  } else if (objectNamespaceType === 'agnostic') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      delay: "long",
      title: globalObjectTypeTitle,
      content: globalObjectTypeContent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
      space: {
        id: '*',
        initials: '*',
        color: '#D3DAE6'
      },
      isDisabled: true,
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }));
  }
  const canAssignSpaces = !capabilities || !!capabilities.savedObjectsManagement.shareIntoSpace;
  const clickProperties = canAssignSpaces ? {
    cursorStyle: 'pointer',
    listOnClick
  } : {
    cursorStyle: 'not-allowed'
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LazySpaceList, (0, _extends2.default)({}, spaceListProps, clickProperties, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  })), showFlyout && /*#__PURE__*/_react.default.createElement(LazyShareToSpaceFlyout, (0, _extends2.default)({}, flyoutProps, {
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 22
    }
  })));
};
class ShareToSpaceSavedObjectsManagementColumn extends _types.SavedObjectsManagementColumn {
  constructor(spacesApiUi) {
    super();
    (0, _defineProperty2.default)(this, "id", 'share_saved_objects_to_space');
    (0, _defineProperty2.default)(this, "euiColumn", {
      field: 'namespaces',
      name: columnName,
      description: columnDescription,
      render: (namespaces, record) => {
        var _this$columnContext;
        const spaceListProps = {
          namespaces: namespaces !== null && namespaces !== void 0 ? namespaces : [],
          behaviorContext: 'outside-space'
        };
        const flyoutProps = {
          savedObjectTarget: {
            type: record.type,
            id: record.id,
            namespaces: namespaces !== null && namespaces !== void 0 ? namespaces : [],
            title: record.meta.title,
            icon: record.meta.icon
          },
          flyoutIcon: 'share',
          onUpdate: updatedObjects => this.objectsToRefresh = [...updatedObjects],
          onClose: this.onClose,
          enableCreateCopyCallout: true,
          enableCreateNewSpaceLink: true
        };
        return /*#__PURE__*/_react.default.createElement(Wrapper, {
          objectType: record.type,
          objectNamespaceType: record.meta.namespaceType,
          spacesApiUi: this.spacesApiUi,
          capabilities: (_this$columnContext = this.columnContext) === null || _this$columnContext === void 0 ? void 0 : _this$columnContext.capabilities,
          spaceListProps: spaceListProps,
          flyoutProps: flyoutProps,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 161,
            columnNumber: 9
          }
        });
      }
    });
    (0, _defineProperty2.default)(this, "refreshOnFinish", () => this.objectsToRefresh);
    (0, _defineProperty2.default)(this, "objectsToRefresh", []);
    (0, _defineProperty2.default)(this, "onClose", () => {
      this.finish();
    });
    this.spacesApiUi = spacesApiUi;
  }
}
exports.ShareToSpaceSavedObjectsManagementColumn = ShareToSpaceSavedObjectsManagementColumn;