"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBulkUpdateTagsPainlessScript = exports.UPDATE_TAGS_SCRIPT = void 0;
var _technical_rule_data_field_names = require("../../common/technical_rule_data_field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPDATE_TAGS_SCRIPT = exports.UPDATE_TAGS_SCRIPT = `
  // --- Step 1: Ensure list exists ---
  // If the tags field is not a list (e.g., null or wrong type),
  // initialize it as a new, empty list.

  if (!(ctx._source['${_technical_rule_data_field_names.ALERT_WORKFLOW_TAGS}'] instanceof List)) {
    ctx._source['${_technical_rule_data_field_names.ALERT_WORKFLOW_TAGS}'] = new ArrayList();
  }
      
  // --- Step 2: Remove ---
  // Check if parameter is a valid list before removing

  if (params.remove instanceof List) {
    ctx._source['${_technical_rule_data_field_names.ALERT_WORKFLOW_TAGS}'].removeIf(tag -> params.remove.contains(tag));
  }

  // --- Step 3: Add ---
  // Check if parameter is a valid list before adding

  if (params.add instanceof List) {
    for (String tagToAdd : params.add) {
      // Add the new tag only if it's not already in the list
      if (!ctx._source['${_technical_rule_data_field_names.ALERT_WORKFLOW_TAGS}'].contains(tagToAdd)) {
        ctx._source['${_technical_rule_data_field_names.ALERT_WORKFLOW_TAGS}'].add(tagToAdd);
      }
    }
  }
`;
const getBulkUpdateTagsPainlessScript = (add, remove) => {
  return {
    source: UPDATE_TAGS_SCRIPT,
    lang: 'painless',
    params: {
      add: add !== null && add !== void 0 ? add : [],
      remove: remove !== null && remove !== void 0 ? remove : []
    }
  };
};
exports.getBulkUpdateTagsPainlessScript = getBulkUpdateTagsPainlessScript;