"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateReportingLicense = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateReportingLicense = async ({
  reporting,
  responseFactory
}) => {
  // check license
  const licenseInfo = await reporting.getLicenseInfo();
  const licenseResults = licenseInfo.scheduledReports;
  if (!licenseResults.enableLinks) {
    throw responseFactory.forbidden({
      body: licenseResults.message
    });
  }
};
exports.validateReportingLicense = validateReportingLicense;