"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInternalBulkDeleteRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _reportingCommon = require("@kbn/reporting-common");
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _scheduled_reports = require("../../../../services/scheduled_reports");
var _common = require("../../../common");
var _request_handler = require("../../../common/request_handler");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  SCHEDULED
} = _reportingCommon.INTERNAL_ROUTES;
const registerInternalBulkDeleteRoute = ({
  logger,
  router,
  reporting
}) => {
  const path = SCHEDULED.BULK_DELETE;
  router.delete({
    path,
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization'
      }
    },
    validate: {
      body: _configSchema.schema.object({
        ids: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
          minSize: 1,
          maxSize: 50
        })
      })
    },
    options: {
      access: 'internal'
    }
  }, (0, _common.authorizedUserPreRouting)(reporting, async (user, context, req, res) => {
    try {
      const counters = (0, _common.getCounters)(req.route.method, path, reporting.getUsageCounter());

      // ensure the async dependencies are loaded
      if (!context.reporting) {
        return (0, _request_handler.handleUnavailable)(res);
      }
      await (0, _utils.validateReportingLicense)({
        reporting,
        responseFactory: res
      });
      const {
        ids
      } = req.body;
      const scheduledReportsService = await _scheduled_reports.ScheduledReportsService.build({
        logger,
        reportingCore: reporting,
        request: req,
        responseFactory: res
      });
      const results = await scheduledReportsService.bulkDelete({
        user,
        ids
      });
      counters.usageCounter();
      return res.ok({
        body: results,
        headers: {
          'content-type': 'application/json'
        }
      });
    } catch (err) {
      if (err instanceof _coreHttpRouterServerInternal.KibanaResponse) {
        return err;
      }
      throw err;
    }
  }));
};
exports.registerInternalBulkDeleteRoute = registerInternalBulkDeleteRoute;