"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkEnable = void 0;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _reportingPublic = require("@kbn/reporting-public");
var _bulk_enable_scheduled_reports = require("../apis/bulk_enable_scheduled_reports");
var _mutation_keys = require("../mutation_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKey = _mutation_keys.mutationKeys.bulkEnableScheduledReports;
const useBulkEnable = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _reportingPublic.useKibana)().services;
  return (0, _reactQuery.useMutation)({
    mutationKey: getKey(),
    mutationFn: ({
      ids
    }) => (0, _bulk_enable_scheduled_reports.bulkEnableScheduledReports)({
      http,
      ids
    }),
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.reporting.schedules.reports.enableError', {
          defaultMessage: 'Error enabling scheduled report'
        })
      });
    },
    onSuccess: () => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.reporting.schedules.reports.enabled', {
        defaultMessage: 'Scheduled report enabled'
      }));
      queryClient.invalidateQueries({
        queryKey: ['reporting', 'scheduledList'],
        refetchType: 'active'
      });
    }
  });
};
exports.useBulkEnable = useBulkEnable;