"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateScheduledReportForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _convert_to_rrule = require("@kbn/response-ops-recurring-schedule-form/utils/convert_to_rrule");
var _reportingPublic = require("@kbn/reporting-public");
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _eui = require("@elastic/eui");
var _reportingCommon = require("@kbn/reporting-common");
var _utils = require("../utils");
var _scheduled_report_form = require("./scheduled_report_form");
var i18n = _interopRequireWildcard(require("../translations"));
var _report_params = require("../report_params");
var _use_schedule_report = require("../hooks/use_schedule_report");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/create_scheduled_report_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateScheduledReportForm = ({
  apiClient,
  objectType,
  sharingData,
  scheduledReport,
  availableReportTypes,
  onClose
}) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _reportingPublic.useKibana)().services;
  const reportingPageLink = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: http.basePath.prepend(_reportingCommon.REPORTING_MANAGEMENT_SCHEDULES),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, i18n.REPORTING_PAGE_LINK_TEXT), [http.basePath]);
  const {
    mutateAsync: createScheduledReport,
    isLoading: isSubmitLoading
  } = (0, _use_schedule_report.useScheduleReport)({
    http
  });
  const onSubmit = async formData => {
    if (!sharingData || !objectType) {
      return;
    }
    try {
      const {
        title,
        reportTypeId,
        startDate,
        timezone,
        recurringSchedule,
        optimizedForPrinting,
        sendByEmail,
        emailRecipients,
        emailCcRecipients,
        emailBccRecipients,
        emailSubject,
        emailMessage
      } = formData;
      const rrule = (0, _convert_to_rrule.convertToRRule)({
        startDate,
        timezone,
        recurringSchedule,
        includeTime: true
      });
      await createScheduledReport({
        reportTypeId,
        jobParams: (0, _report_params.getReportParams)({
          apiClient,
          sharingData,
          objectType,
          title,
          reportTypeId,
          ...(reportTypeId === 'printablePdfV2' ? {
            optimizedForPrinting
          } : {})
        }),
        schedule: {
          rrule: rrule
        },
        notification: sendByEmail ? {
          email: (0, _utils.transformEmailNotification)({
            emailRecipients,
            emailCcRecipients,
            emailBccRecipients,
            emailSubject,
            emailMessage
          })
        } : undefined
      });
      toasts.addSuccess({
        title: i18n.SCHEDULED_REPORT_FORM_SUCCESS_TOAST_TITLE,
        text: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SCHEDULED_REPORT_FORM_SUCCESS_TOAST_MESSAGE, " ", reportingPageLink, "."))
      });
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(error);
      toasts.addError(error, {
        title: i18n.SCHEDULED_REPORT_FORM_FAILURE_TOAST_TITLE,
        toastMessage: i18n.SCHEDULED_REPORT_FORM_FAILURE_TOAST_MESSAGE
      });
      // Forward error to signal whether to close the flyout or not
      throw error;
    }
  };
  return /*#__PURE__*/_react.default.createElement(_scheduled_report_form.ScheduledReportForm, {
    scheduledReport: scheduledReport,
    availableReportTypes: availableReportTypes,
    onClose: onClose,
    onSubmitForm: onSubmit,
    isSubmitLoading: isSubmitLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  });
};
exports.CreateScheduledReportForm = CreateScheduledReportForm;