"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectionStatus = ConnectionStatus;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/sections/remote_cluster_list/components/connection_status/connection_status.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ConnectionStatus({
  isConnected,
  mode
}) {
  const seedNodeTooltip = _i18n.i18n.translate('xpack.remoteClusters.connectedStatus.notConnectedToolTip', {
    defaultMessage: `Ensure the seed nodes are configured with the remote cluster's transport port, not the http port.`
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: isConnected ? 'success' : 'danger',
    "data-test-subj": "remoteClusterConnectionStatusMessage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  }, isConnected ? _i18n.i18n.translate('xpack.remoteClusters.connectedStatus.connectedAriaLabel', {
    defaultMessage: 'Connected'
  }) : _i18n.i18n.translate('xpack.remoteClusters.connectedStatus.notConnectedAriaLabel', {
    defaultMessage: 'Not connected'
  }))), !isConnected && mode === _constants.SNIFF_MODE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "subdued",
    content: seedNodeTooltip,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  })));
}
ConnectionStatus.propTypes = {
  isConnected: _propTypes.default.bool,
  mode: _propTypes.default.oneOf([_constants.SNIFF_MODE, _constants.PROXY_MODE])
};