"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectionModeCloud = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../services/documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/sections/components/remote_cluster_config_steps/remote_cluster_form/components/connection_mode_cloud.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConnectionModeCloud = props => {
  const {
    fields,
    fieldsErrors,
    areErrorsVisible,
    onFieldsChange
  } = props;
  const {
    cloudRemoteAddress,
    serverName,
    proxySocketConnections,
    cloudAdvancedOptionsEnabled
  } = fields;
  const {
    cloudRemoteAddress: cloudRemoteAddressError
  } = fieldsErrors;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.sectionModeTitle",
      defaultMessage: "Connection mode",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.sectionModeCloudDescription",
      defaultMessage: "Configure how to connect to the remote cluster.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.advancedOptionsToggleLabel",
        defaultMessage: "Configure advanced options",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 17
        }
      }),
      checked: cloudAdvancedOptionsEnabled,
      "data-test-subj": "remoteClusterFormCloudAdvancedOptionsToggle",
      onChange: e => onFieldsChange({
        cloudAdvancedOptionsEnabled: e.target.checked
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    })),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormRemoteAddressFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldRemoteAddressLabel",
      defaultMessage: "Remote address",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldRemoteAddressHelpText",
      defaultMessage: "Must include a valid hostname, IPv4, or IPv6 address. When no port is specified, the default {default_port} port is used.",
      values: {
        default_port: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 96,
            columnNumber: 29
          }
        }, '9400')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }),
    isInvalid: Boolean(areErrorsVisible && cloudRemoteAddressError),
    error: cloudRemoteAddressError,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: cloudRemoteAddress,
    placeholder: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.fieldRemoteAddressPlaceholder', {
      defaultMessage: 'hostname:port'
    }),
    onChange: e => onFieldsChange({
      cloudRemoteAddress: e.target.value
    }),
    isInvalid: Boolean(areErrorsVisible && cloudRemoteAddressError),
    "data-test-subj": "remoteClusterFormRemoteAddressInput",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })), cloudAdvancedOptionsEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormTLSServerNameFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldTLSServerNameLabel",
      defaultMessage: "TLS server name (optional)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 15
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldTLSServerNameHelpText",
      defaultMessage: "If the remote cluster certificate has a different server name, specify it here. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.proxySettingsUrl,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.remoteClusterForm.fieldTLSServerNameHelpText.learnMoreLinkLabel",
          defaultMessage: "Learn more.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 136,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 15
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: serverName,
    onChange: e => onFieldsChange({
      serverName: e.target.value
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormProxySocketConnectionsFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldProxySocketConnectionsLabel",
      defaultMessage: "Socket connections",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 15
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldSocketConnectionsHelpText",
      defaultMessage: "The number of connections to open per remote cluster.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 15
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: proxySocketConnections || '',
    onChange: e => onFieldsChange({
      proxySocketConnections: Number(e.target.value)
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }))));
};
exports.ConnectionModeCloud = ConnectionModeCloud;