"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KIBANA_PLATFORM = exports.KIBANA_GROUPS = void 0;
var _solutions = require("./solutions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The base group, for all modules that are commonly used across solutions.
 */
const KIBANA_PLATFORM = exports.KIBANA_PLATFORM = 'platform';

/**
 * A list of all Kibana groups (platform + solutions).
 */
const KIBANA_GROUPS = exports.KIBANA_GROUPS = [KIBANA_PLATFORM, ..._solutions.KIBANA_SOLUTIONS];

/**
 * A type that defines the existing groups (platform + solutions).
 */

/**
 * The groups to which a module can belong.
 * 'common' is the default for uncategorised modules.
 */

/**
 * ModuleVisibility tells whether a module is accessible from any module (shared) or only from modules of the same group (private)
 */