"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserInfo = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUserInfo = async ({
  request,
  security,
  logger
}) => {
  if (!security) {
    logger.debug('Security plugin is not available, skipping user info fetch');
    return undefined;
  }
  try {
    const userProfile = await security.userProfiles.getCurrent({
      request
    });
    if (userProfile != null) {
      var _userProfile$user$ful, _userProfile$user$ema;
      // Use display name priority: full_name > email > username
      const displayName = userProfile.user.full_name || userProfile.user.email || userProfile.user.username;
      return {
        username: displayName,
        full_name: (_userProfile$user$ful = userProfile.user.full_name) !== null && _userProfile$user$ful !== void 0 ? _userProfile$user$ful : null,
        email: (_userProfile$user$ema = userProfile.user.email) !== null && _userProfile$user$ema !== void 0 ? _userProfile$user$ema : null,
        profile_uid: userProfile.uid
      };
    }
  } catch (error) {
    logger.debug(`Failed to retrieve user profile, falling back to authc: ${error}`);
  }
  try {
    const user = security.authc.getCurrentUser(request);
    if (user != null) {
      var _user$full_name, _user$email;
      // Use display name priority: full_name > email > username
      const displayName = user.full_name || user.email || user.username;
      return {
        username: displayName,
        full_name: (_user$full_name = user.full_name) !== null && _user$full_name !== void 0 ? _user$full_name : null,
        email: (_user$email = user.email) !== null && _user$email !== void 0 ? _user$email : null,
        profile_uid: null
      };
    }
  } catch (error) {
    logger.debug(`Failed to retrieve user info from authc: ${error}`);
  }
  return undefined;
};
exports.getUserInfo = getUserInfo;