"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OsqueryAction = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _prompts = require("../prompts");
var _translations = require("./translations");
var _kibana = require("../../common/lib/kibana");
var _live_queries = require("../../live_queries");
var _osquery_icon = require("../../components/osquery_icon");
var _use_is_osquery_available = require("../use_is_osquery_available");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/shared_components/osquery_action/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OsqueryActionComponent = ({
  agentId,
  formType = 'simple',
  defaultValues,
  hideAgentsField,
  onSuccess
}) => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const {
    osqueryAvailable,
    agentFetched,
    isLoading,
    policyFetched,
    policyLoading,
    agentData
  } = (0, _use_is_osquery_available.useIsOsqueryAvailable)(agentId);
  if (agentId && agentFetched && !agentData) {
    return /*#__PURE__*/_react.default.createElement(_prompts.OsqueryEmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 12
      }
    });
  }
  if ((!permissions.runSavedQueries || !permissions.readSavedQueries) && !permissions.writeLiveQueries) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_osquery_icon.OsqueryIcon, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 16
        }
      }, _translations.PERMISSION_DENIED),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.osquery.action.missingPrivileges",
        defaultMessage: "To access this page, ask your administrator for {osquery} Kibana privileges."
        // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
        ,
        values: {
          osquery: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 59,
              columnNumber: 26
            }
          }, "osquery")
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    });
  }
  if (agentId && isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 10,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 12
      }
    });
  }
  if (agentId && !policyFetched && policyLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 10,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 12
      }
    });
  }
  if (agentId && !osqueryAvailable) {
    return /*#__PURE__*/_react.default.createElement(_prompts.OsqueryNotAvailablePrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 12
      }
    });
  }
  if (agentId && (agentData === null || agentData === void 0 ? void 0 : agentData.status) !== 'online') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_osquery_icon.OsqueryIcon, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 15
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 16
        }
      }, _translations.SHORT_EMPTY_TITLE),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 15
        }
      }, _translations.AGENT_STATUS_ERROR),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_live_queries.LiveQuery, (0, _extends2.default)({
    formType: formType,
    agentId: agentId,
    hideAgentsField: hideAgentsField,
    onSuccess: onSuccess
  }, defaultValues, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }));
};
OsqueryActionComponent.displayName = 'OsqueryAction';
const OsqueryAction = exports.default = exports.OsqueryAction = /*#__PURE__*/_react.default.memo(OsqueryActionComponent);

// eslint-disable-next-line import/no-default-export