"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PacksTable = exports.AgentPoliciesPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _kibana = require("../common/lib/kibana");
var _use_packs = require("./use_packs");
var _active_state_switch = require("./active_state_switch");
var _agents_policy_link = require("../agent_policies/agents_policy_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/packs_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const updatedAtCss = {
  whiteSpace: 'nowrap',
  overflow: 'hidden',
  textOverflow: 'ellipsis'
};
const EMPTY_ARRAY = [];
const ScheduledQueryNameComponent = ({
  id,
  name
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _kibana.useRouterNavigate)(`packs/${id}`), {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 3
  }
}), name);
const ScheduledQueryName = /*#__PURE__*/_react.default.memo(ScheduledQueryNameComponent);
const renderName = (_, item) => /*#__PURE__*/_react.default.createElement(ScheduledQueryName, {
  id: item.saved_object_id,
  name: item.name,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 3
  }
});
const AgentPoliciesPopover = ({
  agentPolicyIds = []
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(currentIsPopoverOpen => !currentIsPopoverOpen), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const button = (0, _react.useMemo)(() => {
    var _agentPolicyIds$lengt;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "both",
      onClick: onButtonClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_agentPolicyIds$lengt = agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.length) !== null && _agentPolicyIds$lengt !== void 0 ? _agentPolicyIds$lengt : 0));
  }, [agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.length, onButtonClick]);
  if (!(agentPolicyIds !== null && agentPolicyIds !== void 0 && agentPolicyIds.length)) {
    var _agentPolicyIds$lengt2;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_agentPolicyIds$lengt2 = agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.length) !== null && _agentPolicyIds$lengt2 !== void 0 ? _agentPolicyIds$lengt2 : 0);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.map(policyId => /*#__PURE__*/_react.default.createElement("div", {
    key: policyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_agents_policy_link.AgentsPolicyLink, {
    policyId: policyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  })))));
};
exports.AgentPoliciesPopover = AgentPoliciesPopover;
const PacksTableComponent = () => {
  var _data$data;
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const {
    push
  } = (0, _reactRouterDom.useHistory)();
  const {
    data,
    isLoading
  } = (0, _use_packs.usePacks)({});
  const renderAgentPolicy = (0, _react.useCallback)(agentPolicyIds => /*#__PURE__*/_react.default.createElement(AgentPoliciesPopover, {
    agentPolicyIds: agentPolicyIds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 30
    }
  }), []);
  const renderQueries = (0, _react.useCallback)(queries => {
    var _ref;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_ref = queries && Object.keys(queries).length) !== null && _ref !== void 0 ? _ref : 0);
  }, []);
  const renderActive = (0, _react.useCallback)((_, item) => /*#__PURE__*/_react.default.createElement(_active_state_switch.ActiveStateSwitch, {
    item: item,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 59
    }
  }), []);
  const renderUpdatedAt = (0, _react.useCallback)((updatedAt, item) => {
    if (!updatedAt) return '-';
    const updatedBy = item.updated_by !== item.created_by ? ` @ ${item.updated_by}` : '';
    return updatedAt ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: `${(0, _momentTimezone.default)(updatedAt).fromNow()}${updatedBy}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      css: updatedAtCss,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, `${(0, _momentTimezone.default)(updatedAt).fromNow()}${updatedBy}`)) : '-';
  }, []);
  const handlePlayClick = (0, _react.useCallback)(item => () => push('/live_queries/new', {
    form: {
      packId: item.saved_object_id
    }
  }), [push]);
  const renderPlayAction = (0, _react.useCallback)((item, enabled) => {
    const playText = _i18n.i18n.translate('xpack.osquery.packs.table.runActionAriaLabel', {
      defaultMessage: 'Run {packName}',
      values: {
        packName: item.name
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: playText,
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "play",
      onClick: handlePlayClick(item),
      isDisabled: !enabled,
      "data-test-subj": `play-${item.name}-button`,
      "aria-label": playText,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }));
  }, [handlePlayClick]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.osquery.packs.table.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    sortable: item => item.name.toLowerCase(),
    render: renderName
  }, {
    field: 'policy_ids',
    name: _i18n.i18n.translate('xpack.osquery.packs.table.policyColumnTitle', {
      defaultMessage: 'Scheduled policies'
    }),
    truncateText: true,
    render: renderAgentPolicy
  }, {
    field: 'queries',
    name: _i18n.i18n.translate('xpack.osquery.packs.table.numberOfQueriesColumnTitle', {
      defaultMessage: 'Number of queries'
    }),
    render: renderQueries,
    width: '150px'
  }, {
    field: 'created_by',
    name: _i18n.i18n.translate('xpack.osquery.packs.table.createdByColumnTitle', {
      defaultMessage: 'Created by'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'updated_at',
    name: 'Last updated',
    sortable: item => item.updated_at ? Date.parse(item.updated_at) : 0,
    truncateText: true,
    render: renderUpdatedAt
  }, {
    field: 'enabled',
    name: _i18n.i18n.translate('xpack.osquery.packs.table.activeColumnTitle', {
      defaultMessage: 'Active'
    }),
    sortable: true,
    align: 'right',
    width: '80px',
    render: renderActive
  }, {
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    width: '80px',
    actions: [{
      render: renderPlayAction,
      enabled: () => permissions.writeLiveQueries || permissions.runSavedQueries
    }]
  }], [permissions.runSavedQueries, permissions.writeLiveQueries, renderActive, renderAgentPolicy, renderPlayAction, renderQueries, renderUpdatedAt]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: 'name',
      direction: 'asc'
    }
  }), []);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 10,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: (_data$data = data === null || data === void 0 ? void 0 : data.data) !== null && _data$data !== void 0 ? _data$data : EMPTY_ARRAY,
    columns: columns,
    pagination: true,
    sorting: sorting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 5
    }
  });
};
const PacksTable = exports.PacksTable = /*#__PURE__*/_react.default.memo(PacksTableComponent);