"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigUploader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/fleet_integration/config_uploader.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SUPPORTED_CONFIG_EXTENSIONS = ['application/json', 'text/plain'];
const ExampleConfigLink = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: "https://github.com/osquery/osquery/blob/master/tools/deployment/osquery.example.conf",
  target: "_blank",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.osquery.configUploader.exampleConfigLinkLabel",
  defaultMessage: "Example config",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 24,
    columnNumber: 5
  }
})));
ExampleConfigLink.displayName = 'ExampleOsqueryConfigLink';
const ConfigUploaderComponent = ({
  onChange
}) => {
  const filePickerRef = (0, _react.useRef)(null);
  const [isInvalid, setIsInvalid] = (0, _react.useState)(null);
  // @ts-expect-error update types
  let fileReader;
  const handleFileRead = () => {
    var _filePickerRef$curren2;
    // @ts-expect-error update types
    const content = fileReader.result;
    let parsedContent;
    try {
      parsedContent = JSON.parse(content.replaceAll('\\\n', ''), (key, value) => {
        if (key === 'query') {
          // remove any multiple spaces from the query
          return value.replaceAll(/\s(?=\s)/gm, '');
        }
        return value;
      });
      setIsInvalid(null);
    } catch (error) {
      var _filePickerRef$curren;
      setIsInvalid(error);
      (_filePickerRef$curren = filePickerRef.current) === null || _filePickerRef$curren === void 0 ? void 0 : _filePickerRef$curren.removeFiles();
    }
    onChange(parsedContent);
    (_filePickerRef$curren2 = filePickerRef.current) === null || _filePickerRef$curren2 === void 0 ? void 0 : _filePickerRef$curren2.removeFiles();
  };

  // @ts-expect-error update types
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const handleFileChosen = file => {
    fileReader = new FileReader();
    fileReader.onloadend = handleFileRead;
    fileReader.readAsText(file);
  };
  const handleInputChange = (0, _react.useCallback)(inputFiles => {
    var _ref;
    if (!inputFiles.length) {
      return;
    }
    if (inputFiles.length && ((_ref = !!inputFiles[0].type.length && !SUPPORTED_CONFIG_EXTENSIONS.includes(inputFiles[0].type)) !== null && _ref !== void 0 ? _ref : !inputFiles[0].name.endsWith('.conf'))) {
      var _filePickerRef$curren3;
      setIsInvalid(_i18n.i18n.translate('xpack.osquery.configUploader.unsupportedFileTypeText', {
        defaultMessage: 'File type {fileType} is not supported, please upload {supportedFileTypes} config file',
        values: {
          fileType: inputFiles[0].type,
          supportedFileTypes: SUPPORTED_CONFIG_EXTENSIONS.join(' or ')
        }
      }));
      // @ts-expect-error update types
      (_filePickerRef$curren3 = filePickerRef.current) === null || _filePickerRef$curren3 === void 0 ? void 0 : _filePickerRef$curren3.removeFiles(new Event('fake'));
      return;
    }
    handleFileChosen(inputFiles[0]);
  }, [handleFileChosen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    labelAppend: /*#__PURE__*/_react.default.createElement(ExampleConfigLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 22
      }
    }),
    isInvalid: !!isInvalid,
    error: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${isInvalid}`),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    ref: filePickerRef,
    id: "osquery_config_picker",
    initialPromptText: _i18n.i18n.translate('xpack.osquery.configUploader.initialPromptTextLabel', {
      defaultMessage: 'Select or drag and drop osquery config file'
    }),
    onChange: handleInputChange,
    display: "large",
    fullWidth: true,
    isInvalid: !!isInvalid,
    accept: SUPPORTED_CONFIG_EXTENSIONS.join(','),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })));
};
const ConfigUploader = exports.ConfigUploader = /*#__PURE__*/_react.default.memo(ConfigUploaderComponent);