"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActionResults = void 0;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _kibana = require("../common/lib/kibana");
var _constants = require("../../common/constants");
var _agent_fields = require("../../common/utils/agent_fields");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useActionResults = ({
  actionId,
  activePage,
  agentIds,
  direction,
  limit,
  sortField,
  kuery,
  startDate,
  isLive = false
}) => {
  var _agentIds$length2;
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  const currentPageAgentIds = (0, _react.useMemo)(() => {
    const startIndex = activePage * limit;
    const endIndex = startIndex + limit;
    return (agentIds === null || agentIds === void 0 ? void 0 : agentIds.slice(startIndex, endIndex)) || [];
  }, [agentIds, activePage, limit]);
  return (0, _reactQuery.useQuery)(['actionResults', {
    actionId,
    activePage,
    limit,
    direction,
    sortField
  }], () => {
    var _agentIds$length;
    return http.get(`/api/osquery/action_results/${actionId}`, {
      version: _constants.API_VERSIONS.public.v1,
      query: {
        page: activePage,
        pageSize: limit,
        sort: sortField,
        sortOrder: direction,
        ...(kuery && {
          kuery
        }),
        ...(startDate && {
          startDate
        }),
        ...(currentPageAgentIds.length > 0 && {
          agentIds: currentPageAgentIds.join(',')
        }),
        totalAgents: (_agentIds$length = agentIds === null || agentIds === void 0 ? void 0 : agentIds.length) !== null && _agentIds$length !== void 0 ? _agentIds$length : 0
      }
    });
  }, {
    select: response => {
      // Server already filtered by agentIds - build set of responded agents
      const respondedAgentIds = new Set(response.edges.map(edge => (0, _agent_fields.getAgentIdFromFields)(edge.fields)).filter(id => id !== undefined));
      const placeholderEdges = currentPageAgentIds.filter(agentId => agentId && !respondedAgentIds.has(agentId)).map(agentId => ({
        _index: `${_constants.ACTION_RESPONSES_INDEX}-default`,
        _id: `placeholder-${agentId}`,
        _source: {},
        fields: {
          agent_id: [agentId]
        }
      }));
      const mergedEdges = [...response.edges, ...placeholderEdges];
      return {
        edges: mergedEdges,
        aggregations: response.aggregations,
        inspect: response.inspect || {
          dsl: [],
          response: []
        }
      };
    },
    initialData: {
      edges: [],
      total: 0,
      currentPage: 0,
      pageSize: limit,
      totalPages: 0,
      aggregations: {
        totalRowCount: 0,
        totalResponded: 0,
        successful: 0,
        pending: (_agentIds$length2 = agentIds === null || agentIds === void 0 ? void 0 : agentIds.length) !== null && _agentIds$length2 !== void 0 ? _agentIds$length2 : 0,
        failed: 0
      },
      inspect: {
        dsl: [],
        response: []
      }
    },
    refetchInterval: isLive ? 5000 : false,
    keepPreviousData: true,
    enabled: !!actionId && !!(agentIds !== null && agentIds !== void 0 && agentIds.length),
    onSuccess: () => setErrorToast(),
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.action_results.fetchError', {
        defaultMessage: 'Error while fetching action results'
      })
    })
  });
};
exports.useActionResults = useActionResults;