"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionResultsSummary = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@kbn/react-query");
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _use_action_results = require("./use_action_results");
var _search_strategy = require("../../common/search_strategy");
var _kibana = require("../common/lib/kibana");
var _constants = require("../../common/constants");
var _use_error_toast = require("../common/hooks/use_error_toast");
var _agent_fields = require("../../common/utils/agent_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/action_results/action_results_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Use Elasticsearch's native SearchHit type for result edges

const DEFAULT_PAGE_SIZE = 20;
const DEFAULT_PAGE_INDEX = 0;
const AGENT_DETAILS_CACHE_TIME_MS = 30000;
const TABLE_MAX_HEIGHT_PX = 500;
const ESTIMATED_ROW_HEIGHT_PX = 41; // EUI table row default height
const BULK_AGENT_DETAILS_ROUTE = '/internal/osquery/fleet_wrapper/agents/_bulk';
const renderErrorMessage = error => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  language: "shell",
  fontSize: "s",
  paddingSize: "none",
  transparentBackground: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 3
  }
}, error);

// Calculate minimum table body height based on expected rows on current page
const calculateMinTableBodyHeight = (pageSize, pageIndex, totalItemCount) => {
  const expectedItemsOnPage = Math.min(pageSize, Math.max(0, totalItemCount - pageIndex * pageSize));
  const minHeight = expectedItemsOnPage > 0 ? Math.min(expectedItemsOnPage * ESTIMATED_ROW_HEIGHT_PX, TABLE_MAX_HEIGHT_PX) : 0;
  return minHeight;
};

// CSS-in-JS styles for scrollable table with dynamic height
const createStatusTableCss = (pageSize, pageIndex, totalItemCount) => ({
  '.euiTable': {
    display: 'block'
  },
  '.euiTable thead': {
    display: 'table',
    width: '100%',
    tableLayout: 'fixed'
  },
  '.euiTable tbody': {
    display: 'block',
    minHeight: `${calculateMinTableBodyHeight(pageSize, pageIndex, totalItemCount)}px`,
    maxHeight: `${TABLE_MAX_HEIGHT_PX}px`,
    overflowY: 'auto'
  },
  '.euiTable tbody tr': {
    display: 'table',
    width: '100%',
    tableLayout: 'fixed'
  }
});
const ActionResultsSummaryComponent = ({
  actionId,
  expirationDate,
  agentIds,
  error,
  startDate
}) => {
  const {
    http,
    application
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(DEFAULT_PAGE_INDEX);
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  const expired = (0, _react.useMemo)(() => !expirationDate ? false : new Date(expirationDate) < new Date(), [expirationDate]);
  const [isLive, setIsLive] = (0, _react.useState)(true);
  const {
    data
  } = (0, _use_action_results.useActionResults)({
    actionId,
    startDate,
    activePage: pageIndex,
    agentIds,
    limit: pageSize,
    direction: _search_strategy.Direction.asc,
    sortField: '@timestamp',
    isLive
  });

  // Extract agent IDs from current page edges
  // Note: Supports both ECS formatted ['agent.id'] and legacy format (agent_id)
  const currentPageAgentIds = (0, _react.useMemo)(() => data.edges.map(edge => (0, _agent_fields.getAgentIdFromFields)(edge.fields)).filter(Boolean), [data.edges]);

  // Bulk fetch agent details for current page using POST (avoids URL length limits)
  const {
    data: agentsData
  } = (0, _reactQuery.useQuery)(['bulkAgentDetails', currentPageAgentIds], async () => {
    if (currentPageAgentIds.length === 0) return {
      agents: []
    };
    return http.post(BULK_AGENT_DETAILS_ROUTE, {
      version: _constants.API_VERSIONS.internal.v1,
      body: JSON.stringify({
        agentIds: currentPageAgentIds
      })
    });
  }, {
    enabled: currentPageAgentIds.length > 0,
    staleTime: AGENT_DETAILS_CACHE_TIME_MS,
    onError: err => {
      setErrorToast(err, {
        title: _i18n.i18n.translate('xpack.osquery.bulkAgentDetails.fetchError', {
          defaultMessage: 'Error fetching agent details'
        }),
        toastMessage: _i18n.i18n.translate('xpack.osquery.bulkAgentDetails.fetchErrorMessage', {
          defaultMessage: 'Failed to load agent names. Please check your network connection and try again.'
        })
      });
    }
  });

  // Create agent ID to name map
  const agentNameMap = (0, _react.useMemo)(() => {
    var _agentsData$agents;
    const map = new Map();
    agentsData === null || agentsData === void 0 ? void 0 : (_agentsData$agents = agentsData.agents) === null || _agentsData$agents === void 0 ? void 0 : _agentsData$agents.forEach(agent => {
      var _agent$local_metadata, _agent$local_metadata2;
      const hostname = ((_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.host) === null || _agent$local_metadata2 === void 0 ? void 0 : _agent$local_metadata2.name) || agent.id;
      map.set(agent.id, hostname);
    });
    return map;
  }, [agentsData]);

  // Enrich edges with error states immutably
  const enrichedEdges = (0, _react.useMemo)(() => data.edges.map(edge => {
    var _edge$fields, _edge$fields2, _edge$fields3, _edge$fields4;
    // If edge already has error/completed state, return as-is
    if ((_edge$fields = edge.fields) !== null && _edge$fields !== void 0 && _edge$fields.error || (_edge$fields2 = edge.fields) !== null && _edge$fields2 !== void 0 && _edge$fields2['error.skipped'] || (_edge$fields3 = edge.fields) !== null && _edge$fields3 !== void 0 && _edge$fields3.completed_at) {
      return edge;
    }

    // Create new edge with error fields if needed
    const fields = {
      ...(edge.fields || {})
    };
    if (error) {
      fields['error.skipped'] = [error];
      fields.error = [error];
    } else if (expired && !((_edge$fields4 = edge.fields) !== null && _edge$fields4 !== void 0 && _edge$fields4.completed_at)) {
      const expiredMessage = _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.expiredErrorText', {
        defaultMessage: 'The action request timed out.'
      });
      fields['error.keyword'] = [expiredMessage];
      fields.error = [expiredMessage];
    }
    return {
      ...edge,
      fields
    };
  }), [data.edges, error, expired]);
  const renderAgentIdColumn = (0, _react.useCallback)(agentId => {
    const agentName = agentNameMap.get(agentId) || agentId;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 45
        }
      }, agentId),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      className: "eui-textTruncate",
      href: application.getUrlForApp(_common.PLUGIN_ID, {
        path: _public.pagePathGetters.agent_details({
          agentId
        })[1]
      }),
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 11
      }
    }, agentName));
  }, [agentNameMap, application]);
  const renderRowsColumn = (0, _react.useCallback)(rowsCount => rowsCount !== null && rowsCount !== void 0 ? rowsCount : '-', []);
  const renderStatusColumn = (0, _react.useCallback)((_, item) => {
    var _item$fields, _item$fields2, _item$fields3;
    if ((_item$fields = item.fields) !== null && _item$fields !== void 0 && _item$fields['error.skipped']) {
      return _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.skippedStatusText', {
        defaultMessage: 'skipped'
      });
    }
    if (!((_item$fields2 = item.fields) !== null && _item$fields2 !== void 0 && _item$fields2.completed_at)) {
      return expired ? _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.expiredStatusText', {
        defaultMessage: 'expired'
      }) : _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.pendingStatusText', {
        defaultMessage: 'pending'
      });
    }
    if ((_item$fields3 = item.fields) !== null && _item$fields3 !== void 0 && _item$fields3['error.keyword']) {
      return _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.errorStatusText', {
        defaultMessage: 'error'
      });
    }
    return _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.successStatusText', {
      defaultMessage: 'success'
    });
  }, [expired]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'status',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.statusColumnTitle', {
      defaultMessage: 'Status'
    }),
    render: renderStatusColumn
  }, {
    field: 'fields.agent_id[0]',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.agentIdColumnTitle', {
      defaultMessage: 'Agent Id'
    }),
    truncateText: true,
    render: renderAgentIdColumn
  }, {
    field: '_source.action_response.osquery.count',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.resultRowsNumberColumnTitle', {
      defaultMessage: 'Number of result rows'
    }),
    render: renderRowsColumn
  }, {
    field: 'fields.error[0]',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.errorColumnTitle', {
      defaultMessage: 'Error'
    }),
    render: renderErrorMessage
  }], [renderAgentIdColumn, renderRowsColumn, renderStatusColumn]);
  const onTableChange = (0, _react.useCallback)(({
    page
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
  }, []);
  const pagination = (0, _react.useMemo)(() => {
    var _agentIds$length;
    return {
      initialPageSize: DEFAULT_PAGE_SIZE,
      pageIndex,
      pageSize,
      totalItemCount: (_agentIds$length = agentIds === null || agentIds === void 0 ? void 0 : agentIds.length) !== null && _agentIds$length !== void 0 ? _agentIds$length : 0,
      pageSizeOptions: [10, 20, 50, 100],
      showPerPageOptions: true
    };
  }, [pageIndex, pageSize, agentIds === null || agentIds === void 0 ? void 0 : agentIds.length]);
  const statusTableCss = (0, _react.useMemo)(() => {
    var _agentIds$length2;
    return createStatusTableCss(pageSize, pageIndex, (_agentIds$length2 = agentIds === null || agentIds === void 0 ? void 0 : agentIds.length) !== null && _agentIds$length2 !== void 0 ? _agentIds$length2 : 0);
  }, [pageSize, pageIndex, agentIds === null || agentIds === void 0 ? void 0 : agentIds.length]);

  // Guard against race conditions when updating isLive
  const currentAgentCountRef = (0, _react.useRef)(agentIds === null || agentIds === void 0 ? void 0 : agentIds.length);
  (0, _react.useEffect)(() => {
    // Only update if agentIds length hasn't changed during render (prevents race conditions)
    if (currentAgentCountRef.current === (agentIds === null || agentIds === void 0 ? void 0 : agentIds.length)) {
      setIsLive(() => {
        if (!(agentIds !== null && agentIds !== void 0 && agentIds.length) || expired || error) return false;
        return data.aggregations.totalResponded !== (agentIds === null || agentIds === void 0 ? void 0 : agentIds.length);
      });
    }
    currentAgentCountRef.current = agentIds === null || agentIds === void 0 ? void 0 : agentIds.length;
  }, [agentIds === null || agentIds === void 0 ? void 0 : agentIds.length, data.aggregations.totalResponded, error, expired]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: statusTableCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLive,
    items: enrichedEdges,
    columns: columns,
    pagination: pagination,
    onChange: onTableChange,
    tableLayout: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 7
    }
  }));
};
const ActionResultsSummary = exports.ActionResultsSummary = /*#__PURE__*/_react.default.memo(ActionResultsSummaryComponent);