"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAllowedBuiltinTool = exports.isAllowedBuiltinAgent = exports.AGENT_BUILDER_BUILTIN_TOOLS = exports.AGENT_BUILDER_BUILTIN_AGENTS = void 0;
var _tools = require("@kbn/onechat-common/tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is a manually maintained list of all built-in tools registered in Agent Builder.
 * The intention is to force a code review from the Agent Builder team when any team adds a new tool.
 */
const AGENT_BUILDER_BUILTIN_TOOLS = exports.AGENT_BUILDER_BUILTIN_TOOLS = [
// platform core tools are registered from the agent builder plugin so will trigger a review anyway
...Object.values(_tools.platformCoreTools),
// Observability
'observability.get_data_sources', 'observability.get_anomaly_detection_jobs', 'observability.run_log_rate_analysis', 'observability.get_alerts', 'observability.get_services', 'observability.get_downstream_dependencies'];

/**
 * This is a manually maintained list of all built-in agents registered in Agent Builder.
 * The intention is to force a code review from the Agent Builder team when any team adds a new agent.
 */
const AGENT_BUILDER_BUILTIN_AGENTS = exports.AGENT_BUILDER_BUILTIN_AGENTS = ['observability.agent'];
const isAllowedBuiltinTool = toolName => {
  return AGENT_BUILDER_BUILTIN_TOOLS.includes(toolName);
};
exports.isAllowedBuiltinTool = isAllowedBuiltinTool;
const isAllowedBuiltinAgent = agentName => {
  return AGENT_BUILDER_BUILTIN_AGENTS.includes(agentName);
};
exports.isAllowedBuiltinAgent = isAllowedBuiltinAgent;