"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.paramValueTypeSchema = exports.paramSchema = exports.configurationUpdateSchema = exports.configurationSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const paramValueTypeSchema = exports.paramValueTypeSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('text'), _configSchema.schema.literal('keyword'), _configSchema.schema.literal('long'), _configSchema.schema.literal('integer'), _configSchema.schema.literal('double'), _configSchema.schema.literal('float'), _configSchema.schema.literal('boolean'), _configSchema.schema.literal('date'), _configSchema.schema.literal('object'), _configSchema.schema.literal('nested')]);
const paramSchema = exports.paramSchema = _configSchema.schema.object({
  type: paramValueTypeSchema,
  description: _configSchema.schema.string(),
  optional: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  defaultValue: _configSchema.schema.conditional(_configSchema.schema.siblingRef('optional'), true, _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number(), _configSchema.schema.boolean(), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()), _configSchema.schema.arrayOf(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))])), _configSchema.schema.never())
});
const configurationSchema = exports.configurationSchema = _configSchema.schema.object({
  query: _configSchema.schema.string(),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), paramSchema)
});
const configurationUpdateSchema = exports.configurationUpdateSchema = _configSchema.schema.object({
  query: _configSchema.schema.maybe(_configSchema.schema.string()),
  params: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), paramSchema))
});