"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createToolConverter = exports.createAttachmentsService = void 0;
var _converter = require("../../tools/builtin/converter");
var _tool_conversion = require("../../tools/utils/tool_conversion");
var _definitions = require("../../tools/tool_types/definitions");
var _availability_cache = require("../../tools/builtin/availability_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAttachmentsService = ({
  attachmentsStart,
  toolsStart,
  runner,
  request,
  spaceId
}) => {
  const toolConverterFn = createToolConverter({
    request,
    spaceId,
    definitions: toolsStart.getToolDefinitions(),
    runner
  });
  return {
    getTypeDefinition: type => {
      return attachmentsStart.getTypeDefinition(type);
    },
    convertAttachmentTool: toolConverterFn
  };
};
exports.createAttachmentsService = createAttachmentsService;
const createToolConverter = ({
  request,
  spaceId,
  definitions,
  runner
}) => {
  const definitionMap = definitions.filter(def => !(0, _definitions.isDisabledDefinition)(def)).reduce((map, def) => {
    map[def.toolType] = def;
    return map;
  }, {});
  const context = {
    spaceId,
    request
  };
  const cache = new _availability_cache.ToolAvailabilityCache();
  return tool => {
    const definition = definitionMap[tool.type];
    const converted = {
      ...tool,
      tags: []
    };
    const internal = (0, _converter.convertTool)({
      tool: converted,
      context,
      definition,
      cache
    });
    return (0, _tool_conversion.toExecutableTool)({
      tool: internal,
      request,
      runner,
      asInternal: true
    });
  };
};
exports.createToolConverter = createToolConverter;