"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertErrors = convertErrors;
var _rxjs = require("rxjs");
var _onechatCommon = require("@kbn/onechat-common");
var _tracing = require("../../../tracing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertErrors({
  logger,
  trackingService,
  conversationId
}) {
  return $source => {
    return $source.pipe((0, _rxjs.catchError)(err => {
      logger.error(`Error executing agent: ${err.stack}`);
      if (trackingService) {
        try {
          trackingService.trackError(err, conversationId);
        } catch (e) {
          // continue
        }
      }
      return (0, _rxjs.throwError)(() => {
        const traceId = (0, _tracing.getCurrentTraceId)();
        if ((0, _onechatCommon.isOnechatError)(err)) {
          err.meta = {
            ...err.meta,
            traceId
          };
          return err;
        } else {
          return (0, _onechatCommon.createInternalError)(`Error executing agent: ${err.message}`, {
            statusCode: 500,
            traceId
          });
        }
      });
    }));
  };
}