"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAttachmentService = exports.AttachmentServiceImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _attachment_type_registry = require("./attachment_type_registry");
var _validate_attachment = require("./validate_attachment");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAttachmentService = () => {
  return new AttachmentServiceImpl();
};
exports.createAttachmentService = createAttachmentService;
class AttachmentServiceImpl {
  constructor() {
    (0, _defineProperty2.default)(this, "attachmentTypeRegistry", void 0);
    this.attachmentTypeRegistry = (0, _attachment_type_registry.createAttachmentTypeRegistry)();
  }
  setup() {
    return {
      registerType: attachmentType => this.attachmentTypeRegistry.register(attachmentType)
    };
  }
  start() {
    return {
      validate: attachment => {
        return (0, _validate_attachment.validateAttachment)({
          attachment,
          registry: this.attachmentTypeRegistry
        });
      },
      getTypeDefinition: attachment => {
        return this.attachmentTypeRegistry.get(attachment);
      }
    };
  }
}
exports.AttachmentServiceImpl = AttachmentServiceImpl;