"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveConfiguration = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resolveConfiguration = configuration => {
  var _configuration$resear, _configuration$resear2, _configuration$answer, _configuration$answer2, _ref, _configuration$resear3, _configuration$resear4, _ref2, _configuration$answer3, _configuration$answer4;
  let researchInstructions = (_configuration$resear = (_configuration$resear2 = configuration.research) === null || _configuration$resear2 === void 0 ? void 0 : _configuration$resear2.instructions) !== null && _configuration$resear !== void 0 ? _configuration$resear : '';
  let answerInstructions = (_configuration$answer = (_configuration$answer2 = configuration.answer) === null || _configuration$answer2 === void 0 ? void 0 : _configuration$answer2.instructions) !== null && _configuration$answer !== void 0 ? _configuration$answer : '';
  if (configuration.instructions) {
    researchInstructions = researchInstructions ? `${researchInstructions}\n${configuration.instructions}` : configuration.instructions;
    answerInstructions = answerInstructions ? `${answerInstructions}\n${configuration.instructions}` : configuration.instructions;
  }
  return {
    research: {
      instructions: researchInstructions,
      replace_default_instructions: (_ref = (_configuration$resear3 = (_configuration$resear4 = configuration.research) === null || _configuration$resear4 === void 0 ? void 0 : _configuration$resear4.replace_default_instructions) !== null && _configuration$resear3 !== void 0 ? _configuration$resear3 : configuration.replace_default_instructions) !== null && _ref !== void 0 ? _ref : false
    },
    answer: {
      instructions: answerInstructions,
      replace_default_instructions: (_ref2 = (_configuration$answer3 = (_configuration$answer4 = configuration.answer) === null || _configuration$answer4 === void 0 ? void 0 : _configuration$answer4.replace_default_instructions) !== null && _configuration$answer3 !== void 0 ? _configuration$answer3 : configuration.replace_default_instructions) !== null && _ref2 !== void 0 ? _ref2 : false
    }
  };
};
exports.resolveConfiguration = resolveConfiguration;