"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHasConnectorsAllPrivileges = void 0;
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true if the user has access to connectors with all privileges.
 * Currently used in the Agent Builder application to determine whether to show the Gen AI Settings external links.
 *
 * @returns {boolean} True if the user has all connector privileges (show, execute, delete, save)
 */
const useHasConnectorsAllPrivileges = () => {
  var _application$capabili, _application$capabili2, _application$capabili3, _application$capabili4;
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    application
  } = services;
  const hasConnectorsAllPrivilege = ((_application$capabili = application.capabilities.actions) === null || _application$capabili === void 0 ? void 0 : _application$capabili.show) === true && ((_application$capabili2 = application.capabilities.actions) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.execute) === true && ((_application$capabili3 = application.capabilities.actions) === null || _application$capabili3 === void 0 ? void 0 : _application$capabili3.delete) === true && ((_application$capabili4 = application.capabilities.actions) === null || _application$capabili4 === void 0 ? void 0 : _application$capabili4.save) === true;
  return hasConnectorsAllPrivilege;
};
exports.useHasConnectorsAllPrivileges = useHasConnectorsAllPrivileges;