"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsAgentReadOnly = void 0;
var _use_agent_by_id = require("./use_agent_by_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsAgentReadOnly = agentId => {
  const {
    agent
  } = (0, _use_agent_by_id.useOnechatAgentById)(agentId);
  return !!(agent !== null && agent !== void 0 && agent.readonly);
};
exports.useIsAgentReadOnly = useIsAgentReadOnly;