"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolsTableColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("../../../utils/i18n");
var _tool_tags = require("../tags/tool_tags");
var _tools_table_context_menu = require("./tools_table_context_menu");
var _tools_table_id = require("./tools_table_id");
var _tools_table_quick_actions = require("./tools_table_quick_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/table/tools_table_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getToolsTableColumns = ({
  canManageTools
}) => {
  return [
  // Readonly indicator
  {
    width: '30px',
    render: tool => tool.readonly ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "lock",
      content: _i18n.labels.tools.readOnly,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 25
      }
    }) : null
  }, {
    field: 'id',
    name: _i18n.labels.tools.toolIdLabel,
    sortable: true,
    width: '60%',
    render: (_, tool) => /*#__PURE__*/_react.default.createElement(_tools_table_id.ToolIdWithDescription, {
      tool: tool,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 44
      }
    })
  }, {
    field: 'tags',
    name: _i18n.labels.tools.tagsLabel,
    render: tags => /*#__PURE__*/_react.default.createElement(_tool_tags.OnechatToolTags, {
      tags: tags,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 35
      }
    })
  }, {
    width: '100px',
    align: 'right',
    render: tool => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "flexEnd",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, !tool.readonly && canManageTools && /*#__PURE__*/_react.default.createElement(_tools_table_quick_actions.ToolQuickActions, {
      tool: tool,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 48
      }
    }), /*#__PURE__*/_react.default.createElement(_tools_table_context_menu.ToolContextMenu, {
      tool: tool,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    }))
  }];
};
exports.getToolsTableColumns = getToolsTableColumns;