"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOOLS_FORM_REGISTRY = void 0;
exports.getCreatePayloadFromData = getCreatePayloadFromData;
exports.getEditableToolTypes = getEditableToolTypes;
exports.getToolTypeConfig = getToolTypeConfig;
exports.getToolTypeDefaultValues = getToolTypeDefaultValues;
exports.getUpdatePayloadFromData = getUpdatePayloadFromData;
var _onechatCommon = require("@kbn/onechat-common");
var _esql = require("./tool_types/esql");
var _index_search = require("./tool_types/index_search");
var _builtin = require("./tool_types/builtin");
var _workflow = require("./tool_types/workflow");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOOLS_FORM_REGISTRY = exports.TOOLS_FORM_REGISTRY = {
  [_onechatCommon.ToolType.esql]: _esql.esqlToolFormRegistryEntry,
  [_onechatCommon.ToolType.index_search]: _index_search.indexSearchToolRegistryEntry,
  [_onechatCommon.ToolType.workflow]: _workflow.workflowToolRegistryEntry,
  [_onechatCommon.ToolType.builtin]: _builtin.builtinToolRegistryEntry
};
function getToolTypeConfig(toolType) {
  const config = TOOLS_FORM_REGISTRY[toolType];
  if (!config) {
    throw new Error(`Unknown tool type: ${toolType}`);
  }
  return config;
}
function getCreatePayloadFromData(data) {
  const config = getToolTypeConfig(data.type);
  return config.formDataToCreatePayload(data);
}
function getUpdatePayloadFromData(data) {
  const config = getToolTypeConfig(data.type);
  return config.formDataToUpdatePayload(data);
}
function getEditableToolTypes() {
  return Object.entries(TOOLS_FORM_REGISTRY).filter(([toolType]) => toolType !== _onechatCommon.ToolType.builtin).map(([toolType, config]) => ({
    value: toolType,
    text: config.label
  }));
}
function getToolTypeDefaultValues(toolType) {
  const config = getToolTypeConfig(toolType);
  return config.defaultValues;
}