"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workflowToolRegistryEntry = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _workflow = require("@kbn/onechat-common/tools/types/workflow");
var _workflow_configuration_fields = require("../../sections/configuration_fields/workflow_configuration_fields");
var _transform_workflow_form_data = require("../../../../../utils/transform_workflow_form_data");
var _workflow_tool_form_validation = require("../../validation/workflow_tool_form_validation");
var _zod_resolver = require("../../../../../utils/zod_resolver");
var _i18n = require("../../i18n");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const workflowToolRegistryEntry = exports.workflowToolRegistryEntry = {
  label: _i18n.i18nMessages.configuration.form.type.workflowOption,
  getConfigurationComponent: () => _workflow_configuration_fields.WorkflowConfiguration,
  defaultValues: {
    ..._common.commonToolFormDefaultValues,
    type: _onechatCommon.ToolType.workflow,
    workflow_id: '',
    wait_for_completion: true
  },
  toolToFormData: tool => {
    if (!(0, _workflow.isWorkflowTool)(tool)) {
      throw new Error('Expected workflow tool');
    }
    return (0, _transform_workflow_form_data.transformWorkflowToolToFormData)(tool);
  },
  formDataToCreatePayload: _transform_workflow_form_data.transformWorkflowFormDataForCreate,
  formDataToUpdatePayload: _transform_workflow_form_data.transformWorkflowFormDataForUpdate,
  getValidationResolver: services => {
    if (!(services !== null && services !== void 0 && services.toolsService)) {
      throw new Error('toolsService is required for workflow validation');
    }
    return (0, _zod_resolver.zodResolver)((0, _workflow_tool_form_validation.createWorkflowFormValidationSchema)(services.toolsService));
  }
};