"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEsqlParamsValidation = void 0;
var _react = require("react");
var _reactHookForm = require("react-hook-form");
var _esqlUtils = require("@kbn/esql-utils");
var _i18n = require("../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEsqlParamsValidation = () => {
  const {
    getValues,
    setValue,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const triggerEsqlParamWarnings = (0, _react.useCallback)(() => {
    const esql = getValues('esql');
    const formParams = getValues('params');
    if (!formParams) return;
    const inferredParams = new Set((0, _esqlUtils.getESQLQueryVariables)(esql));
    formParams.forEach((param, index) => {
      const shouldWarn = param.name && !inferredParams.has(param.name);
      setValue(`params.${index}.warning`, shouldWarn ? _i18n.i18nMessages.paramUnusedWarning(param.name) : undefined, {
        shouldValidate: false,
        shouldDirty: true
      });
    });
  }, [getValues, setValue]);
  const triggerEsqlParamFieldsValidation = (0, _react.useCallback)(fieldsToValidate => {
    const fieldPaths = getValues('params').flatMap((_, i) => fieldsToValidate.map(field => `params.${i}.${field}`));
    trigger(fieldPaths);
  }, [trigger, getValues]);
  return {
    triggerEsqlParamWarnings,
    triggerEsqlParamFieldsValidation
  };
};
exports.useEsqlParamsValidation = useEsqlParamsValidation;