"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewConversationPrompt = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _conversation_input = require("./conversation_input/conversation_input");
var _conversation = require("./conversation.styles");
var _conversation_context = require("../../context/conversation/conversation_context");
var _tech_preview = require("../common/tech_preview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/new_conversation_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const titleStyles = (0, _react2.css)`
  font-weight: 400;
`;
const NewConversationPrompt = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isEmbeddedContext
  } = (0, _conversation_context.useConversationContext)();
  const centerFlexItemStyles = (0, _react2.css)`
    justify-content: center;
    align-items: center;
    gap: ${euiTheme.size.base};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    direction: "column",
    justifyContent: "center",
    gutterSize: "l",
    css: _conversation.conversationElementWidthStyles,
    "data-test-subj": "agentBuilderWelcomePage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isEmbeddedContext ? true : false,
    css: centerFlexItemStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_tech_preview.TechPreviewBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    css: titleStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.onechat.conversations.newConversationPrompt', {
    defaultMessage: 'How can I help you?'
  })))), /*#__PURE__*/_react.default.createElement(_conversation_input.ConversationInput, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
};
exports.NewConversationPrompt = NewConversationPrompt;