"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundResponseActions = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_toasts = require("../../../../hooks/use_toasts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_response/round_response_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  copy: _i18n.i18n.translate('xpack.onechat.roundResponseActions.copy', {
    defaultMessage: 'Copy response'
  }),
  copySuccess: _i18n.i18n.translate('xpack.onechat.roundResponseActions.copySuccess', {
    defaultMessage: 'Response copied to clipboard'
  })
};
const RoundResponseActions = ({
  content,
  isVisible
}) => {
  const {
    addSuccessToast
  } = (0, _use_toasts.useToasts)();
  const handleCopy = (0, _react2.useCallback)(() => {
    const isSuccess = (0, _copyToClipboard.default)(content);
    if (isSuccess) {
      addSuccessToast(labels.copySuccess);
    }
  }, [content, addSuccessToast]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    iconType: "copyClipboard",
    "aria-label": labels.copy,
    onClick: handleCopy,
    color: "text",
    css: (0, _react.css)`
            opacity: ${isVisible ? 1 : 0};
            transition: opacity 0.2s ease;
          `,
    "data-test-subj": "roundResponseCopyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  })));
};
exports.RoundResponseActions = RoundResponseActions;