"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundInput = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _conversation = require("../conversation.styles");
var _attachment_pills_row = require("../conversation_input/attachment_pills_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  userMessage: _i18n.i18n.translate('xpack.onechat.round.userInput', {
    defaultMessage: 'User input'
  })
};
const RoundInput = ({
  input,
  attachments
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const backgroundColorStyle = {
    background: `linear-gradient(
          90deg,
          ${euiTheme.colors.backgroundBasePrimary} 0%,
          ${euiTheme.colors.backgroundBasePrimary} 70%,
          ${euiTheme.colors.backgroundBaseSubdued} 100%
        )`
  };
  const inputContainerStyles = (0, _react.css)`
    align-self: end;
    max-inline-size: 90%;
    background: ${backgroundColorStyle.background};
    ${(0, _eui.euiTextBreakWord)()}
    white-space: pre-wrap;
    border-radius: ${`${_conversation.ROUNDED_BORDER_RADIUS_LARGE} ${_conversation.ROUNDED_BORDER_RADIUS_LARGE} 0 ${_conversation.ROUNDED_BORDER_RADIUS_LARGE}`};
  `;
  const visibleAttachments = (0, _react2.useMemo)(() => {
    if (!attachments) return [];
    return attachments.filter(attachment => !attachment.hidden);
  }, [attachments]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    css: inputContainerStyles,
    paddingSize: "m",
    hasShadow: false,
    hasBorder: false,
    "aria-label": labels.userMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, input)))), visibleAttachments.length > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_attachment_pills_row.AttachmentPillsRow, {
    attachments: visibleAttachments,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  })));
};
exports.RoundInput = RoundInput;