"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _onechatCommon = require("@kbn/onechat-common");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _round_error_thinking_title = require("./round_error_thinking_title");
var _context_exceeded_round_error = require("./context_exceeded_round_error");
var _generic_round_error = require("./generic_round_error");
var _round_error_thinking_panel = require("./round_error_thinking_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_error/round_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  retryAriaLabel: _i18n.i18n.translate('xpack.onechat.round.error.retryLabel', {
    defaultMessage: 'Retry'
  }),
  tryAgain: _i18n.i18n.translate('xpack.onechat.round.error.tryAgain', {
    defaultMessage: 'Try again?'
  })
};
const RoundError = ({
  error,
  onRetry
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [showErrorThinkingPanel, setShowErrorThinkingPanel] = (0, _react.useState)(false);
  const toggleErrorThinkingPanel = () => {
    setShowErrorThinkingPanel(!showErrorThinkingPanel);
  };
  const errorContent = (0, _onechatCommon.isContextLengthExceededAgentError)(error) ? /*#__PURE__*/_react.default.createElement(_context_exceeded_round_error.ContextExceededRoundError, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_generic_round_error.GenericRoundError, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    responsive: false,
    "data-test-subj": "agentBuilderRoundError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, showErrorThinkingPanel ? /*#__PURE__*/_react.default.createElement(_round_error_thinking_panel.RoundErrorThinkingPanel, {
    onClose: toggleErrorThinkingPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, errorContent) : /*#__PURE__*/_react.default.createElement(_round_error_thinking_title.RoundErrorThinkingTitle, {
    onClick: toggleErrorThinkingPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: (0, _react2.css)`
              color: ${euiTheme.colors.textPrimary};
            `,
    "data-test-subj": "agentBuilderRoundErrorRetryButton",
    iconType: "refresh",
    onClick: onRetry,
    "aria-label": labels.retryAriaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, labels.tryAgain))));
};
exports.RoundError = RoundError;