"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttachmentPill = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _attachments = require("@kbn/onechat-common/attachments");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/attachment_pill.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getAttachmentIcon = type => {
  switch (type) {
    case _attachments.AttachmentType.text:
      return 'document';
    case _attachments.AttachmentType.screenContext:
      return 'inspect';
    case _attachments.AttachmentType.esql:
      return 'editorCodeBlock';
    default:
      return 'document';
  }
};
const getAttachmentDisplayName = type => {
  switch (type) {
    case _attachments.AttachmentType.text:
      return _i18n.i18n.translate('xpack.onechat.attachmentPill.textAttachment', {
        defaultMessage: 'Text'
      });
    case _attachments.AttachmentType.screenContext:
      return _i18n.i18n.translate('xpack.onechat.attachmentPill.screenContextAttachment', {
        defaultMessage: 'Screen context'
      });
    case _attachments.AttachmentType.esql:
      return _i18n.i18n.translate('xpack.onechat.attachmentPill.esqlAttachment', {
        defaultMessage: 'ES|QL query'
      });
    default:
      return type;
  }
};
const AttachmentPill = ({
  id,
  type
}) => {
  const displayName = getAttachmentDisplayName(type);
  const iconType = getAttachmentIcon(type);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    iconType: iconType,
    iconSide: "left",
    "data-test-subj": `onechatAttachmentPill-${id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, displayName);
};
exports.AttachmentPill = AttachmentPill;