"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentSelectDropdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _app_paths = require("../../../utils/app_paths");
var _use_navigation = require("../../../hooks/use_navigation");
var _i18n = require("../../../utils/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/agent_select_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const agentSelectId = 'agentBuilderAgentSelect';
const AgentSelectButton = ({
  selectedAgentName,
  onClick
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconSide: "right",
  flush: "both",
  iconType: "arrowDown",
  onClick: onClick,
  "aria-haspopup": "menu",
  "aria-labelledby": agentSelectId,
  "data-test-subj": "agentBuilderAgentSelectorButton",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 3
  }
}, selectedAgentName);
const AgentSelectDropdown = ({
  selectedAgent,
  onAgentChange,
  agents = []
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const options = (0, _react.useMemo)(() => agents.map(agent => ({
    key: agent.id,
    label: agent.name,
    checked: agent.id === (selectedAgent === null || selectedAgent === void 0 ? void 0 : selectedAgent.id) ? 'on' : undefined
  })), [agents, selectedAgent === null || selectedAgent === void 0 ? void 0 : selectedAgent.id]);
  const handleAgentChange = (0, _react.useCallback)(value => {
    var _value$find;
    const newAgentId = (_value$find = value.find(v => v.checked === 'on')) === null || _value$find === void 0 ? void 0 : _value$find.key;
    if (newAgentId) {
      onAgentChange(newAgentId);
      setIsPopoverOpen(false);
    }
  }, [onAgentChange]);
  const panelStyles = (0, _react2.css)`
    inline-size: calc(${euiTheme.size.xxl} * 7);
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelProps: {
      css: panelStyles
    },
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(AgentSelectButton, {
      selectedAgentName: selectedAgent === null || selectedAgent === void 0 ? void 0 : selectedAgent.name,
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    anchorPosition: "upRight",
    closePopover: () => setIsPopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    id: agentSelectId,
    "aria-label": _i18n.labels.conversations.selectAgentAriaLabel,
    searchable: false,
    options: options,
    onChange: handleAgentChange,
    singleSelection: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
                      font-weight: ${euiTheme.font.weight.bold};
                    `,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 19
    }
  }, _i18n.labels.conversations.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: createOnechatUrl(_app_paths.appPaths.agents.list),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 21
    }
  }, _i18n.labels.conversations.manageAgents))))), list, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconSide: "left",
    iconType: "plus",
    size: "s",
    fullWidth: true,
    href: createOnechatUrl(_app_paths.appPaths.agents.new),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, _i18n.labels.conversations.createAnAgent)))));
};
exports.AgentSelectDropdown = AgentSelectDropdown;