"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Labels = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/common/labels.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LabelGroup = ({
  labels
}) => {
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "s",
    role: "list",
    "aria-label": "Labels",
    "data-test-subj": "agentBuilderLabelsList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, labels.map(label => /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    key: label,
    color: "hollow",
    role: "listitem",
    "data-test-subj": `agentBuilderLabel-${label}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }, label)));
};
const ViewMorePopover = ({
  labels,
  totalLabels
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const popoverPanelStyles = (0, _react.css)`
    max-inline-size: calc(${euiTheme.size.xxxxl} * 5);
  `;
  const [isOpen, setIsOpen] = (0, _react2.useState)(false);
  const viewMoreAriaLabel = _i18n.i18n.translate('xpack.onechat.labels.viewMore.ariaLabel', {
    defaultMessage: 'View {hiddenCount} more {hiddenCount, plural, one {label} other {labels}} ({totalCount} total)',
    values: {
      hiddenCount: labels.length,
      totalCount: totalLabels
    }
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    panelProps: {
      css: popoverPanelStyles
    },
    isOpen: isOpen,
    closePopover: () => {
      setIsOpen(false);
    },
    "data-test-subj": "agentBuilderLabelsViewMorePopover",
    "aria-label": "Additional labels",
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      onClick: () => {
        setIsOpen(open => !open);
      },
      "aria-label": viewMoreAriaLabel,
      "aria-expanded": isOpen,
      "data-test-subj": "agentBuilderLabelsViewMoreButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.labels.viewMore.buttonLabel",
      defaultMessage: "View more",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(LabelGroup, {
    labels: labels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
};
const NUM_VISIBLE_LABELS = 4;
const Labels = ({
  labels,
  numVisible = NUM_VISIBLE_LABELS
}) => {
  if (labels.length === 0) {
    return null;
  }
  const visibleLabels = labels.slice(0, numVisible);
  const hiddenLabels = labels.slice(numVisible);
  if (hiddenLabels.length === 0) {
    return /*#__PURE__*/_react2.default.createElement(LabelGroup, {
      labels: visibleLabels,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    "data-test-subj": 'agentBuilderLabelsContainer',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(LabelGroup, {
    labels: visibleLabels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(ViewMorePopover, {
    labels: hiddenLabels,
    totalLabels: labels.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  })));
};
exports.Labels = Labels;