"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExecutionState = void 0;
var _workflows = require("@kbn/workflows");
var _get_workflow_output = require("./get_workflow_output");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the state of a workflow execution.
 */
const getExecutionState = async ({
  executionId,
  spaceId,
  workflowApi
}) => {
  var _execution$workflowId;
  const execution = await workflowApi.getWorkflowExecution(executionId, spaceId);
  if (!execution) {
    return null;
  }
  const state = {
    execution_id: executionId,
    status: execution.status,
    workflow_id: (_execution$workflowId = execution.workflowId) !== null && _execution$workflowId !== void 0 ? _execution$workflowId : 'unknown',
    started_at: execution.startedAt,
    finished_at: execution.finishedAt
  };
  if (execution.status === _workflows.ExecutionStatus.COMPLETED) {
    state.output = (0, _get_workflow_output.getWorkflowOutput)(execution.stepExecutions);
  }
  return state;
};
exports.getExecutionState = getExecutionState;