"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.otherResult = exports.errorResult = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorResult = error => {
  return {
    type: _onechatCommon.ToolResultType.error,
    data: {
      message: error
    }
  };
};
exports.errorResult = errorResult;
const otherResult = data => {
  return {
    type: _onechatCommon.ToolResultType.other,
    data
  };
};
exports.otherResult = otherResult;