"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.platformCoreTools = exports.editableToolTypes = exports.defaultAgentToolIds = exports.activeToolsCountWarningThreshold = void 0;
var _definition = require("./definition");
var _namespaces = require("../base/namespaces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const platformCoreTool = toolName => {
  return `${_namespaces.internalNamespaces.platformCore}.${toolName}`;
};

/**
 * Ids of built-in onechat tools
 */
const platformCoreTools = exports.platformCoreTools = {
  indexExplorer: platformCoreTool('index_explorer'),
  search: platformCoreTool('search'),
  listIndices: platformCoreTool('list_indices'),
  getIndexMapping: platformCoreTool('get_index_mapping'),
  getDocumentById: platformCoreTool('get_document_by_id'),
  generateEsql: platformCoreTool('generate_esql'),
  executeEsql: platformCoreTool('execute_esql'),
  createVisualization: platformCoreTool('create_visualization'),
  getWorkflowExecutionStatus: platformCoreTool('get_workflow_execution_status'),
  productDocumentation: platformCoreTool('product_documentation')
};

/**
 * List of tool types which can be created / edited by a user.
 */
const editableToolTypes = exports.editableToolTypes = [_definition.ToolType.esql, _definition.ToolType.index_search, _definition.ToolType.workflow];
const defaultAgentToolIds = exports.defaultAgentToolIds = [platformCoreTools.search, platformCoreTools.listIndices, platformCoreTools.getIndexMapping, platformCoreTools.getDocumentById, platformCoreTools.getWorkflowExecutionStatus];

/**
 * The number of active tools that will trigger a warning in the UI.
 * Agent will perform poorly if it has too many tools.
 */
const activeToolsCountWarningThreshold = exports.activeToolsCountWarningThreshold = 24;