"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorContext = void 0;
exports.InspectorContextProvider = InspectorContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/inspector-plugin/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_shared/public/contexts/inspector/inspector_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const value = {
  addInspectorRequest: () => {},
  inspectorAdapters: {
    requests: new _common.RequestAdapter()
  }
};
const InspectorContext = exports.InspectorContext = /*#__PURE__*/(0, _react.createContext)(value);
function InspectorContextProvider({
  children
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    inspectorAdapters
  } = value;
  function addInspectorRequest(result) {
    var _ref, _result$data$_inspect, _result$data, _result$data2, _result$data2$mainSta;
    const operations = (_ref = (_result$data$_inspect = (_result$data = result.data) === null || _result$data === void 0 ? void 0 : _result$data._inspect) !== null && _result$data$_inspect !== void 0 ? _result$data$_inspect : (_result$data2 = result.data) === null || _result$data2 === void 0 ? void 0 : (_result$data2$mainSta = _result$data2.mainStatisticsData) === null || _result$data2$mainSta === void 0 ? void 0 : _result$data2$mainSta._inspect) !== null && _ref !== void 0 ? _ref : [];
    operations.forEach(operation => {
      if (operation.response) {
        const {
          id,
          name
        } = operation;
        const requestParams = {
          id,
          name
        };
        const requestResponder = inspectorAdapters.requests.start(name, requestParams, operation.startTime);
        requestResponder.json(operation.json);
        if (operation.stats) {
          requestResponder.stats(operation.stats);
        }
        requestResponder.finish(operation.status, operation.response);
      }
    });
  }
  (0, _react.useEffect)(() => {
    const unregisterCallback = history.listen(newLocation => {
      if (history.location.pathname !== newLocation.pathname) {
        inspectorAdapters.requests.reset();
      }
    });
    return () => {
      unregisterCallback();
    };
  }, [history, inspectorAdapters]);
  return /*#__PURE__*/_react.default.createElement(InspectorContext.Provider, {
    value: {
      ...value,
      addInspectorRequest
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, children);
}