"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _paths = require("../../common/locators/paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RulesLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _deeplinksObservability.rulesLocatorID);
    (0, _defineProperty2.default)(this, "getLocation", async ({
      lastResponse = [],
      params = {},
      search = '',
      status = [],
      type = []
    }) => {
      return {
        app: 'observability',
        path: (0, _public.setStateToKbnUrl)('_a', {
          lastResponse,
          params,
          search,
          status,
          type
        }, {
          useHash: false,
          storeInHashQuery: false
        }, _paths.RULES_PATH),
        state: {}
      };
    });
  }
}
exports.RulesLocatorDefinition = RulesLocatorDefinition;