"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupBy = GroupBy;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/custom_threshold/components/group_by.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function GroupBy({
  options,
  onChange,
  fields,
  ...rest
}) {
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    const groupBy = selectedOptions.map(option => option.label);
    onChange(groupBy);
  }, [onChange]);
  const selectedOptions = Array.isArray(options.groupBy) ? options.groupBy.map(field => ({
    label: field
  })) : options.groupBy ? [{
    label: options.groupBy
  }] : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    "data-test-subj": "thresholdRuleMetricsExplorer-groupBy",
    placeholder: _i18n.i18n.translate('xpack.observability.threshold.ruleExplorer.groupByLabel', {
      defaultMessage: 'Everything'
    }),
    "aria-label": _i18n.i18n.translate('xpack.observability.threshold.ruleExplorer.groupByAriaLabel', {
      defaultMessage: 'Graph per'
    }),
    fullWidth: true,
    singleSelection: false,
    selectedOptions: selectedOptions,
    options: fields.filter(f => f.aggregatable && (f.type === 'string' || f.type === 'ip')).map(f => ({
      label: f.name
    })),
    onChange: handleChange,
    isClearable: true
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }));
}