"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _lodash = require("lodash");
var _paths = require("../../../common/locators/paths");
var _use_fetch_bulk_cases = require("../../hooks/use_fetch_bulk_cases");
var _use_case_view_navigation = require("../../hooks/use_case_view_navigation");
var _kibana_react = require("../../utils/kibana_react");
var _map_rules_params_with_flyout = require("./helpers/map_rules_params_with_flyout");
var _overview_columns = require("./overview_columns");
var _get_sources = require("../alert_sources/get_sources");
var _constants = require("../../pages/rule_details/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/alert_overview/alert_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertOverview = exports.AlertOverview = /*#__PURE__*/(0, _react.memo)(({
  alert,
  pageId,
  alertStatus
}) => {
  var _get;
  const {
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    cases,
    isLoading
  } = (0, _use_fetch_bulk_cases.useFetchBulkCases)({
    ids: alert.fields[_ruleDataUtils.ALERT_CASE_IDS] || []
  });
  const dateFormat = (0, _public.useUiSetting)('dateFormat');
  const [timeRange, setTimeRange] = (0, _react.useState)({
    from: 'now-15m',
    to: 'now'
  });
  const [ruleCriteria, setRuleCriteria] = (0, _react.useState)([]);
  const alertStart = alert.fields[_ruleDataUtils.ALERT_START];
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END];
  const ruleId = (_get = (0, _lodash.get)(alert.fields, _ruleDataUtils.ALERT_RULE_UUID)) !== null && _get !== void 0 ? _get : null;
  const linkToRule = pageId !== _constants.RULE_DETAILS_PAGE_ID && ruleId ? prepend(_paths.paths.observability.ruleDetails(ruleId)) : null;
  (0, _react.useEffect)(() => {
    const mappedRuleParams = (0, _map_rules_params_with_flyout.mapRuleParamsWithFlyout)(alert);
    setRuleCriteria(mappedRuleParams);
  }, [alert]);
  (0, _react.useEffect)(() => {
    setTimeRange((0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(alertStart, alertEnd));
  }, [alertStart, alertEnd]);
  const {
    navigateToCaseView
  } = (0, _use_case_view_navigation.useCaseViewNavigation)();
  const items = (0, _react.useMemo)(() => {
    return [{
      id: _overview_columns.ColumnIDs.STATUS,
      key: _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.status', {
        defaultMessage: 'Status'
      }),
      value: alertStatus || alert.fields[_ruleDataUtils.ALERT_STATUS],
      meta: {
        flapping: alert.fields[_ruleDataUtils.ALERT_FLAPPING]
      }
    }, {
      id: _overview_columns.ColumnIDs.SOURCE,
      key: _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.sources', {
        defaultMessage: 'Affected entity / source'
      }),
      value: [],
      meta: {
        alertEnd,
        timeRange,
        groups: (0, _get_sources.getSources)(alert) || []
      }
    }, {
      id: _overview_columns.ColumnIDs.TRIGGERED,
      key: _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.triggered', {
        defaultMessage: 'Triggered'
      }),
      value: alert.fields[_ruleDataUtils.ALERT_START],
      meta: {
        dateFormat
      }
    }, {
      id: _overview_columns.ColumnIDs.DURATION,
      key: _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.duration', {
        defaultMessage: 'Duration'
      }),
      value: alert.fields[_ruleDataUtils.ALERT_DURATION]
    }, {
      id: _overview_columns.ColumnIDs.OBSERVED_VALUE,
      key: _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.observedValue', {
        defaultMessage: 'Observed value'
      }),
      value: alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUES] || [alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE]],
      meta: {
        ruleCriteria
      }
    }, {
      id: _overview_columns.ColumnIDs.THRESHOLD,
      key: _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.threshold', {
        defaultMessage: 'Threshold'
      }),
      value: [],
      meta: {
        ruleCriteria
      }
    }, {
      id: _overview_columns.ColumnIDs.RULE_NAME,
      key: _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.ruleName', {
        defaultMessage: 'Rule name'
      }),
      value: alert.fields[_ruleDataUtils.ALERT_RULE_NAME],
      meta: {
        ruleLink: alert.fields[_ruleDataUtils.ALERT_RULE_UUID] && prepend(_paths.paths.observability.ruleDetails(alert.fields[_ruleDataUtils.ALERT_RULE_UUID]))
      }
    }, {
      id: _overview_columns.ColumnIDs.RULE_TYPE,
      key: _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.ruleType', {
        defaultMessage: 'Rule type'
      }),
      value: alert.fields[_ruleDataUtils.ALERT_RULE_CATEGORY]
    }, {
      id: _overview_columns.ColumnIDs.CASES,
      key: _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.cases', {
        defaultMessage: 'Cases'
      }),
      value: [],
      meta: {
        cases,
        navigateToCaseView,
        isLoading
      }
    }];
  }, [alertStatus, alert, alertEnd, timeRange, dateFormat, ruleCriteria, prepend, cases, navigateToCaseView, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observability.alertsFlyout.reasonTitle', {
    defaultMessage: 'Reason'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 9
    }
  }, alert.reason), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }), !!linkToRule && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: linkToRule,
    "data-test-subj": "viewRuleDetailsFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observability.alertsFlyout.viewRulesDetailsLinkText', {
    defaultMessage: 'View rule details'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observability.alertsFlyout.documentSummaryTitle', {
    defaultMessage: 'Document Summary'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    width: '80%',
    columns: _overview_columns.overviewColumns,
    itemId: "key",
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }));
});