"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.complete = complete;
var _rxjs = require("rxjs");
var _common = require("../../common");
var _create_function_response_message = require("../../common/utils/create_function_response_message");
var _create_function_response_error = require("../utils/create_function_response_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function complete({
  client,
  getScreenContexts,
  connectorId,
  conversationId,
  messages: initialMessages,
  persist,
  disableFunctions,
  signal,
  instructions,
  scopes
}, requestCallback) {
  return new _rxjs.Observable(subscriber => {
    const screenContexts = getScreenContexts();
    const allActions = screenContexts.flatMap(context => {
      var _context$actions;
      return (_context$actions = context.actions) !== null && _context$actions !== void 0 ? _context$actions : [];
    });
    const response$ = requestCallback({
      params: {
        body: {
          connectorId,
          messages: initialMessages,
          persist,
          disableFunctions,
          screenContexts,
          conversationId,
          instructions,
          scopes
        }
      }
    }).pipe((0, _rxjs.shareReplay)());
    const messages$ = response$.pipe((0, _rxjs.filter)(event => event.type === _common.StreamingChatResponseEventType.MessageAdd), (0, _rxjs.map)(event => event.message), (0, _rxjs.toArray)(), (0, _rxjs.last)());
    const conversationId$ = response$.pipe((0, _rxjs.last)(event => event.type === _common.StreamingChatResponseEventType.ConversationCreate || event.type === _common.StreamingChatResponseEventType.ConversationUpdate), (0, _rxjs.map)(event => event.conversation.id), (0, _rxjs.catchError)(() => {
      return (0, _rxjs.of)(conversationId);
    }));
    response$.subscribe({
      next: val => {
        subscriber.next(val);
      },
      error: error => {
        subscriber.error(error);
      }
    });
    (0, _rxjs.combineLatest)([conversationId$, messages$, response$.pipe((0, _rxjs.last)())]).subscribe({
      next: ([nextConversationId, allMessages]) => {
        var _allMessages;
        const functionCall = (_allMessages = allMessages[allMessages.length - 1]) === null || _allMessages === void 0 ? void 0 : _allMessages.message.function_call;
        if (!(functionCall !== null && functionCall !== void 0 && functionCall.name)) {
          subscriber.complete();
          return;
        }
        const requestedAction = allActions.find(action => action.name === functionCall.name);
        function next(nextMessages) {
          if (nextMessages[nextMessages.length - 1].message.role === _common.MessageRole.Assistant && !persist) {
            subscriber.complete();
            return;
          }
          complete({
            client,
            getScreenContexts,
            connectorId,
            conversationId: nextConversationId || conversationId,
            messages: initialMessages.concat(nextMessages),
            signal,
            persist,
            disableFunctions,
            instructions,
            scopes
          }, requestCallback).subscribe(subscriber);
        }
        if (!requestedAction) {
          const errorMessage = (0, _create_function_response_error.createPublicFunctionResponseError)({
            name: functionCall.name,
            error: new Error(`Requested action ${functionCall.name} was not found`)
          });
          subscriber.next(errorMessage);
          next([...allMessages, errorMessage.message]);
          return;
        }
        requestedAction.respond({
          signal,
          client,
          args: JSON.parse(functionCall.arguments || '{}'),
          connectorId,
          messages: allMessages
        }).then(async functionResponse => {
          if ((0, _rxjs.isObservable)(functionResponse)) {
            const executedMessage = (0, _create_function_response_message.createFunctionResponseMessage)({
              name: functionCall.name,
              content: {
                executed: true
              }
            });
            allMessages.push(executedMessage.message);
            subscriber.next(executedMessage);
            return await new Promise((resolve, reject) => {
              functionResponse.subscribe({
                next: val => {
                  if (val.type === _common.StreamingChatResponseEventType.MessageAdd) {
                    allMessages.push(val.message);
                  }
                  subscriber.next(val);
                },
                error: error => {
                  reject(error);
                },
                complete: () => {
                  resolve();
                }
              });
            });
          }
          return (0, _create_function_response_message.createFunctionResponseMessage)({
            name: functionCall.name,
            content: functionResponse.content,
            data: functionResponse.data
          });
        }).catch(error => {
          return (0, _create_function_response_error.createPublicFunctionResponseError)({
            name: functionCall.name,
            error
          });
        }).then(event => {
          if (event) {
            allMessages.push(event.message);
            subscriber.next(event);
          }
          next(allMessages);
        });
      },
      error: error => {
        subscriber.error(error);
      }
    });
  });
}