"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeBlock = CodeBlock;
exports.EsqlCodeBlock = EsqlCodeBlock;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _types = require("../chat/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/observability_ai_assistant/public/components/message_panel/esql_code_block.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getCodeBlockClassName = theme => (0, _css.css)`
  background-color: ${theme.euiTheme.colors.lightestShade};
  .euiCodeBlock__pre {
    margin-bottom: 0;
    padding: ${theme.euiTheme.size.m};
    min-block-size: 48px;
  }
  .euiCodeBlock__controls {
    inset-block-start: ${theme.euiTheme.size.m};
    inset-inline-end: ${theme.euiTheme.size.m};
  }
`;
function CodeBlockWrapper({
  children
}) {
  const theme = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "s",
    className: getCodeBlockClassName(theme),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, children);
}
function CodeBlock({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(CodeBlockWrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    fontSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, children))));
}
function EsqlCodeBlock({
  value,
  lang,
  actionsDisabled,
  onActionClick
}) {
  return /*#__PURE__*/_react.default.createElement(CodeBlockWrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: lang,
    isCopyable: true,
    fontSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, value)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilityAiAssistantEsqlCodeBlockRunThisQueryButton",
    size: "xs",
    iconType: "play",
    onClick: () => onActionClick({
      type: _types.ChatActionClickType.executeEsqlQuery,
      query: value
    }),
    disabled: actionsDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.runThisQuery', {
    defaultMessage: 'Display results'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilityAiAssistantEsqlCodeBlockVisualizeThisQueryButton",
    size: "xs",
    iconType: "lensApp",
    onClick: () => onActionClick({
      type: _types.ChatActionClickType.visualizeEsqlQuery,
      query: value
    }),
    disabled: actionsDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.visualizeThisQuery', {
    defaultMessage: 'Visualize this query'
  })))))));
}