"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeESQL = VisualizeESQL;
exports.registerVisualizeQueryRenderFunction = registerVisualizeQueryRenderFunction;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/esql-datagrid/public");
var _esqlUtils = require("@kbn/esql-utils");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-ai-assistant-plugin/public");
var _visualizationUtils = require("@kbn/visualization-utils");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _uuid = require("uuid");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/functions/visualize_esql.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VISUALIZE_QUERY_FUNCTION_NAME = 'visualize_query';
function generateId() {
  return (0, _uuid.v4)();
}
const saveVisualizationLabel = _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.save', {
  defaultMessage: 'Save visualization'
});
const editVisualizationLabel = _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.edit', {
  defaultMessage: 'Edit visualization'
});
function VisualizeESQL({
  lens,
  dataViews,
  uiActions,
  columns,
  rows,
  query,
  onActionClick,
  userOverrides,
  preferredChartType,
  ObservabilityAIAssistantMultipaneFlyoutContext,
  errorMessages
}) {
  var _lensInput$attributes;
  const lensHelpersAsync = (0, _useAsync.default)(() => {
    return lens.stateHelperApi();
  }, [lens]);
  const dataViewAsync = (0, _useAsync.default)(() => {
    return (0, _esqlUtils.getESQLAdHocDataview)({
      dataViewsService: dataViews,
      query,
      options: {
        skipFetchFields: true
      }
    });
  }, [query, dataViews]);
  const chatFlyoutSecondSlotHandler = (0, _react.useContext)(ObservabilityAIAssistantMultipaneFlyoutContext);
  const [isSaveModalOpen, setIsSaveModalOpen] = (0, _react.useState)(false);
  const [isTableVisible, setIsTableVisible] = (0, _react.useState)(false);
  const [lensInput, setLensInput] = (0, _react.useState)(userOverrides);
  const [lensLoadEvent, setLensLoadEvent] = (0, _react.useState)(null);
  const onLoad = (0, _react.useCallback)((isLoading, adapters, dataLoading$) => {
    var _adapters$tables;
    const adapterTables = adapters === null || adapters === void 0 ? void 0 : (_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : _adapters$tables.tables;
    if (adapterTables && !isLoading) {
      setLensLoadEvent({
        adapters,
        dataLoading$
      });
    }
  }, []);

  // initialization
  (0, _react.useEffect)(() => {
    if (lensHelpersAsync.value && dataViewAsync.value && !lensInput) {
      var _dataViewAsync$value;
      const context = {
        dataViewSpec: (_dataViewAsync$value = dataViewAsync.value) === null || _dataViewAsync$value === void 0 ? void 0 : _dataViewAsync$value.toSpec(),
        fieldName: '',
        textBasedColumns: columns,
        query: {
          esql: query
        }
      };
      const chartSuggestions = lensHelpersAsync.value.suggestions(context, dataViewAsync.value, [], preferredChartType);
      if (chartSuggestions !== null && chartSuggestions !== void 0 && chartSuggestions.length) {
        const [suggestion] = chartSuggestions;
        const attrs = (0, _visualizationUtils.getLensAttributesFromSuggestion)({
          filters: [],
          query: {
            esql: query
          },
          suggestion,
          dataView: dataViewAsync.value
        });
        const lensEmbeddableInput = {
          attributes: attrs,
          id: generateId()
        };
        setLensInput(lensEmbeddableInput);
      }
    }
  }, [columns, dataViewAsync.value, lensHelpersAsync.value, lensInput, query, preferredChartType]);

  // trigger options to open the inline editing flyout correctly
  const triggerOptions = (0, _react.useMemo)(() => {
    if (lensInput !== null && lensInput !== void 0 && lensInput.attributes) {
      return {
        attributes: lensInput === null || lensInput === void 0 ? void 0 : lensInput.attributes,
        lensEvent: lensLoadEvent !== null && lensLoadEvent !== void 0 ? lensLoadEvent : {
          adapters: {}
        },
        onUpdate: newAttributes => {
          if (lensInput) {
            const newInput = {
              ...lensInput,
              attributes: newAttributes
            };
            setLensInput(newInput);
          }
        },
        onApply: newAttributes => {
          var _chatFlyoutSecondSlot;
          const newInput = {
            ...lensInput,
            attributes: newAttributes
          };
          onActionClick({
            type: _public2.ChatActionClickType.updateVisualization,
            userOverrides: newInput,
            query
          });
          chatFlyoutSecondSlotHandler === null || chatFlyoutSecondSlotHandler === void 0 ? void 0 : (_chatFlyoutSecondSlot = chatFlyoutSecondSlotHandler.setVisibility) === null || _chatFlyoutSecondSlot === void 0 ? void 0 : _chatFlyoutSecondSlot.call(chatFlyoutSecondSlotHandler, false);
          if (chatFlyoutSecondSlotHandler !== null && chatFlyoutSecondSlotHandler !== void 0 && chatFlyoutSecondSlotHandler.container) {
            _reactDom.default.unmountComponentAtNode(chatFlyoutSecondSlotHandler.container);
          }
        },
        onCancel: () => {
          var _chatFlyoutSecondSlot2;
          onActionClick({
            type: _public2.ChatActionClickType.updateVisualization,
            userOverrides: lensInput,
            query
          });
          chatFlyoutSecondSlotHandler === null || chatFlyoutSecondSlotHandler === void 0 ? void 0 : (_chatFlyoutSecondSlot2 = chatFlyoutSecondSlotHandler.setVisibility) === null || _chatFlyoutSecondSlot2 === void 0 ? void 0 : _chatFlyoutSecondSlot2.call(chatFlyoutSecondSlotHandler, false);
          if (chatFlyoutSecondSlotHandler !== null && chatFlyoutSecondSlotHandler !== void 0 && chatFlyoutSecondSlotHandler.container) {
            _reactDom.default.unmountComponentAtNode(chatFlyoutSecondSlotHandler.container);
          }
        },
        container: chatFlyoutSecondSlotHandler === null || chatFlyoutSecondSlotHandler === void 0 ? void 0 : chatFlyoutSecondSlotHandler.container
      };
    }
  }, [chatFlyoutSecondSlotHandler, lensInput, lensLoadEvent, onActionClick, query]);
  if (!lensHelpersAsync.value || !dataViewAsync.value || !lensInput) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 12
      }
    });
  }
  // if the Lens suggestions api suggests a table then we want to render a Discover table instead
  const isLensInputTable = (lensInput === null || lensInput === void 0 ? void 0 : (_lensInput$attributes = lensInput.attributes) === null || _lensInput$attributes === void 0 ? void 0 : _lensInput$attributes.visualizationType) === 'lnsDatatable';
  const visualizationComponentDataTestSubj = isTableVisible ? 'observabilityAiAssistantESQLDataGrid' : 'observabilityAiAssistantESQLLensChart';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }, !!(errorMessages !== null && errorMessages !== void 0 && errorMessages.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.errorMessage', {
    defaultMessage: 'There were some errors in the generated query'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "observabilityAiAssistantErrorsList",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 13
    }
  }, errorMessages.map((error, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      key: index,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "error",
      color: "danger",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 23
      }
    }, error)));
  }))), !isLensInputTable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isTableVisible ? _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.visualization', {
      defaultMessage: 'Visualization'
    }) : _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.table', {
      defaultMessage: 'Table of results'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: isTableVisible ? 'visBarVerticalStacked' : 'tableDensityExpanded',
    onClick: () => setIsTableVisible(!isTableVisible),
    "data-test-subj": "observabilityAiAssistantLensESQLDisplayTableButton",
    "aria-label": isTableVisible ? _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.displayChart', {
      defaultMessage: 'Display chart'
    }) : _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.displayTable', {
      defaultMessage: 'Display table'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: editVisualizationLabel,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "pencil",
    onClick: () => {
      var _chatFlyoutSecondSlot3;
      chatFlyoutSecondSlotHandler === null || chatFlyoutSecondSlotHandler === void 0 ? void 0 : (_chatFlyoutSecondSlot3 = chatFlyoutSecondSlotHandler.setVisibility) === null || _chatFlyoutSecondSlot3 === void 0 ? void 0 : _chatFlyoutSecondSlot3.call(chatFlyoutSecondSlotHandler, true);
      if (triggerOptions) {
        uiActions.getTrigger('IN_APP_EMBEDDABLE_EDIT_TRIGGER').exec(triggerOptions);
      }
    },
    "data-test-subj": "observabilityAiAssistantLensESQLEditButton",
    "aria-label": editVisualizationLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: saveVisualizationLabel,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "save",
    onClick: () => setIsSaveModalOpen(true),
    "data-test-subj": "observabilityAiAssistantLensESQLSaveButton",
    "aria-label": saveVisualizationLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": visualizationComponentDataTestSubj,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 13
    }
  }, isTableVisible ? /*#__PURE__*/_react.default.createElement(_public.ESQLDataGrid, {
    rows: rows,
    columns: columns,
    dataView: dataViewAsync.value,
    query: {
      esql: query
    },
    flyoutType: "overlay",
    isTableView: true,
    initialRowHeight: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, (0, _extends2.default)({}, lensInput, {
    style: {
      height: 240
    },
    onLoad: onLoad,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 17
    }
  })))), isLensInputTable && !(errorMessages !== null && errorMessages !== void 0 && errorMessages.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "observabilityAiAssistantESQLDataGrid",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ESQLDataGrid, {
    rows: rows,
    columns: columns,
    dataView: dataViewAsync.value,
    query: {
      esql: query
    },
    flyoutType: "overlay",
    initialRowHeight: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 13
    }
  }))), isSaveModalOpen ? /*#__PURE__*/_react.default.createElement(lens.SaveModalComponent, {
    initialInput: lensInput,
    onClose: () => {
      setIsSaveModalOpen(() => false);
    }
    // For now, we don't want to allow saving ESQL charts to the library
    ,
    isSaveable: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 9
    }
  }) : null);
}
function registerVisualizeQueryRenderFunction({
  registerRenderFunction,
  pluginsStart
}) {
  registerRenderFunction(VISUALIZE_QUERY_FUNCTION_NAME, ({
    arguments: {
      query,
      userOverrides,
      intention
    },
    response,
    onActionClick
  }) => {
    const typedResponse = response;
    const columns = 'data' in typedResponse ? typedResponse.data.columns : typedResponse.content;
    const rows = 'data' in typedResponse ? typedResponse.data.rows : [];
    const errorMessages = 'content' in typedResponse && 'errorMessages' in typedResponse.content ? typedResponse.content.errorMessages : [];
    const correctedQuery = 'data' in typedResponse && 'correctedQuery' in typedResponse.data ? typedResponse.data.correctedQuery : query;
    if ('data' in typedResponse && 'userOverrides' in typedResponse.data) {
      userOverrides = typedResponse.data.userOverrides;
    }
    let preferredChartType;
    switch (intention) {
      case _public2.VisualizeESQLUserIntention.executeAndReturnResults:
      case _public2.VisualizeESQLUserIntention.generateQueryOnly:
      case _public2.VisualizeESQLUserIntention.visualizeAuto:
        break;
      case _public2.VisualizeESQLUserIntention.visualizeBar:
        preferredChartType = _visualizationUtils.ChartType.Bar;
        break;
      case _public2.VisualizeESQLUserIntention.visualizeDonut:
        preferredChartType = _visualizationUtils.ChartType.Donut;
        break;
      case _public2.VisualizeESQLUserIntention.visualizeHeatmap:
        preferredChartType = _visualizationUtils.ChartType.Heatmap;
        break;
      case _public2.VisualizeESQLUserIntention.visualizeLine:
        preferredChartType = _visualizationUtils.ChartType.Line;
        break;
      case _public2.VisualizeESQLUserIntention.visualizeArea:
        preferredChartType = _visualizationUtils.ChartType.Area;
        break;
      case _public2.VisualizeESQLUserIntention.visualizeTable:
        preferredChartType = _visualizationUtils.ChartType.Table;
        break;
      case _public2.VisualizeESQLUserIntention.visualizeTagcloud:
        preferredChartType = _visualizationUtils.ChartType.Tagcloud;
        break;
      case _public2.VisualizeESQLUserIntention.visualizeTreemap:
        preferredChartType = _visualizationUtils.ChartType.Treemap;
        break;
      case _public2.VisualizeESQLUserIntention.visualizeWaffle:
        preferredChartType = _visualizationUtils.ChartType.Waffle;
        break;
      case _public2.VisualizeESQLUserIntention.visualizeXy:
        preferredChartType = _visualizationUtils.ChartType.XY;
        break;
    }
    const trimmedQuery = correctedQuery.trim();
    return /*#__PURE__*/_react.default.createElement(VisualizeESQL, {
      ObservabilityAIAssistantMultipaneFlyoutContext: pluginsStart.observabilityAIAssistant.ObservabilityAIAssistantMultipaneFlyoutContext,
      lens: pluginsStart.lens,
      dataViews: pluginsStart.dataViews,
      uiActions: pluginsStart.uiActions,
      columns: columns,
      rows: rows,
      query: trimmedQuery,
      onActionClick: onActionClick,
      userOverrides: userOverrides,
      preferredChartType: preferredChartType,
      errorMessages: errorMessages,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 477,
        columnNumber: 9
      }
    });
  });
}