"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRelevantAlertFields = getRelevantAlertFields;
var _lodash = require("lodash");
var _select_relevant_alert_fields = require("./select_relevant_alert_fields");
var _get_hits_total = require("../../utils/get_hits_total");
var _get_typed_search = require("../../utils/get_typed_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getRelevantAlertFields({
  query,
  start,
  end,
  coreStart,
  pluginStart,
  request,
  modelProvider,
  logger
}) {
  const esClient = coreStart.elasticsearch.client.asInternalUser;
  const savedObjectsClient = coreStart.savedObjects.getScopedClient(request);
  const dataViewsService = await pluginStart.dataViews.dataViewsServiceFactory(savedObjectsClient, esClient);
  const search = (0, _get_typed_search.getTypedSearch)(esClient);
  const hasAnyHitsResponse = await search({
    index: '.alerts-observability*',
    _source: false,
    size: 1,
    track_total_hits: 1,
    terminate_after: 1
  });
  const hitCount = (0, _get_hits_total.getHitsTotal)(hasAnyHitsResponse);

  // all fields are empty in this case, so get them all
  const includeEmptyFields = hitCount === 0;
  const fieldsForWildcard = await dataViewsService.getFieldsForWildcard({
    pattern: '.alerts-observability*',
    allowNoIndex: true,
    includeEmptyFields,
    indexFilter: start && end ? {
      range: {
        '@timestamp': {
          gte: start,
          lt: end
        }
      }
    } : undefined
  });
  const allFields = fieldsForWildcard.flatMap(field => {
    var _field$esTypes;
    const types = (_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 ? _field$esTypes : [field.type];
    return types.map(type => ({
      name: field.name,
      type
    }));
  });
  const fieldNames = (0, _lodash.uniq)(allFields.map(field => field.name));
  const groupedFields = (0, _lodash.groupBy)(allFields, field => field.name);
  const selectedFieldNames = await (0, _select_relevant_alert_fields.selectRelevantAlertFields)({
    query,
    candidateFieldNames: fieldNames,
    logger,
    modelProvider
  });
  const selectedFields = selectedFieldNames.map(field => {
    var _groupedFields$field;
    const desc = (_groupedFields$field = groupedFields[field]) !== null && _groupedFields$field !== void 0 ? _groupedFields$field : [];
    const types = desc.map(d => d.type).join(',');
    return types ? `${field}:${types}` : field;
  });
  return selectedFields;
}