"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAgentDataRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityAgentDataRegistry {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "providers", new Map());
    this.logger = logger;
  }
  registerDataProvider(id, provider) {
    if (this.providers.has(id)) {
      this.logger.warn(`Overwriting data provider for key: ${id}`);
    } else {
      this.logger.debug(`Registered data provider for key: ${id}`);
    }
    this.providers.set(id, provider);
  }
  async getData(id, params) {
    const provider = this.providers.get(id);
    if (!provider) {
      this.logger.error(`No data provider registered for key: ${id}`);
      return;
    }
    return provider(params);
  }
}
exports.ObservabilityAgentDataRegistry = ObservabilityAgentDataRegistry;